/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.util;

import dev.felnull.imp.libs.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.imp.libs.org.jsoup.Jsoup;
import dev.felnull.imp.libs.org.jsoup.nodes.Document;
import dev.felnull.imp.libs.org.jsoup.nodes.Element;
import dev.felnull.imp.libs.org.jsoup.select.Elements;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class HTMLUtil {
    public static Component toComponent(String text) {
        Document doc = Jsoup.parse(text = FNStringUtil.decodeHTMLSpecialCharacter(text));
        Element body = doc.body();
        Elements els = body.getAllElements();
        String tx = FNStringUtil.decodeHTMLSpecialCharacter(((Element)els.get(els.size() - 1)).html());
        if (tx.isEmpty()) {
            return null;
        }
        long jbkc = tx.chars().filter(n -> n == 12288).count();
        if (jbkc == (long)tx.length()) {
            return null;
        }
        long bkc = tx.chars().filter(n -> n == 32).count();
        if (bkc == (long)tx.length()) {
            return null;
        }
        TextComponent comp = new TextComponent(tx);
        for (Element el : els) {
            String en = el.tagName();
            try {
                comp = HTMLUtil.toDecoComponent(comp, en, body.select(en));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return comp;
    }

    private static TextComponent toDecoComponent(TextComponent component, String name, Elements element) {
        if ("font".equals(name)) {
            String at = element.attr("color");
            if (at.isEmpty()) {
                return component;
            }
            ChatFormatting cf = ChatFormatting.m_126657_((String)at);
            if (cf != null) {
                return (TextComponent)component.m_130940_(cf);
            }
            if (!at.startsWith("#")) {
                return component;
            }
            int col = Integer.parseInt(at.substring(1), 16);
            return (TextComponent)component.m_130948_(Style.f_131099_.m_178520_(col));
        }
        if ("b".equals(name)) {
            return (TextComponent)component.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        }
        if ("i".equals(name)) {
            return (TextComponent)component.m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
        }
        if ("u".equals(name)) {
            return (TextComponent)component.m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)));
        }
        if ("s".equals(name) || "strike".equals(name)) {
            return (TextComponent)component.m_130948_(Style.f_131099_.m_178522_(Boolean.valueOf(true)));
        }
        return component;
    }
}

