/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItemRinger;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.item.IInstructionItem;
import dev.felnull.otyacraftengine.item.ItemContainer;
import dev.felnull.otyacraftengine.item.location.HandItemLocation;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import dev.felnull.otyacraftengine.util.OEMenuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends BlockItem
implements IInstructionItem {
    public BoomboxItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        super.m_6883_(itemStack, level, entity, i, bl);
        BoomboxItem.tick(level, entity, itemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (BoomboxItem.getTransferProgress(itemStack) == 0 || BoomboxItem.getTransferProgress(itemStack) == 10) {
            if (!level.m_5776_()) {
                if (BoomboxItem.checkDuplication(itemStack, (Entity)player)) {
                    BoomboxItem.setUUID(itemStack, UUID.randomUUID());
                }
                if (player.m_6047_()) {
                    BoomboxItem.setPowerOn(itemStack, !BoomboxItem.isPowerOn(itemStack));
                } else if (BoomboxItem.isPowerOn(itemStack)) {
                    HandItemLocation loc = new HandItemLocation(interactionHand);
                    OEMenuUtil.openItemMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)ItemContainer.createMenuProvider((ItemStack)itemStack, (IPlayerItemLocation)loc, (int)2, (String)"BoomboxItems", BoomboxMenu::new), (IPlayerItemLocation)loc, (ItemStack)itemStack, (int)2);
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public InteractionResult m_40576_(BlockPlaceContext blockPlaceContext) {
        ItemStack itemStack = blockPlaceContext.m_43722_();
        Player player = blockPlaceContext.m_43723_();
        if (player != null && (player.m_6047_() || BoomboxItem.isPowerOn(itemStack))) {
            if (BoomboxItem.getTransferProgress(itemStack) == 0 || BoomboxItem.getTransferProgress(itemStack) == 10) {
                if (!blockPlaceContext.m_43725_().m_5776_()) {
                    if (player.m_6047_()) {
                        if (BoomboxItem.getTransferProgress(itemStack) == 0 || BoomboxItem.getTransferProgress(itemStack) == 10) {
                            BoomboxItem.setPowerOn(itemStack, !BoomboxItem.isPowerOn(itemStack));
                        }
                    } else if (BoomboxItem.isPowerOn(itemStack)) {
                        HandItemLocation loc = new HandItemLocation(blockPlaceContext.m_43724_());
                        OEMenuUtil.openItemMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)ItemContainer.createMenuProvider((ItemStack)itemStack, (IPlayerItemLocation)loc, (int)2, (String)"BoomboxItems", BoomboxMenu::new), (IPlayerItemLocation)loc, (ItemStack)itemStack, (int)2);
                    }
                }
                return InteractionResult.m_19078_((boolean)blockPlaceContext.m_43725_().f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return super.m_40576_(blockPlaceContext);
    }

    protected boolean m_40610_(BlockPlaceContext blockPlaceContext, BlockState blockState) {
        return !BoomboxItem.isPowerOn(blockPlaceContext.m_43722_()) && super.m_40610_(blockPlaceContext, blockState);
    }

    public void m_142023_(ItemEntity itemEntity) {
        if (this.m_40614_() instanceof BoomboxBlock) {
            ItemUtils.m_150952_((ItemEntity)itemEntity, (Stream)BoomboxItem.getContainItem(itemEntity.m_32055_()).stream());
        }
        super.m_142023_(itemEntity);
    }

    public static void tick(Level level, Entity entity, ItemStack stack) {
        Entity entity2 = entity;
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (!level.m_5776_()) {
                if (BoomboxItem.getUUID(stack) == null) {
                    BoomboxItem.setUUID(stack, UUID.randomUUID());
                }
                MusicRingManager mr = MusicRingManager.getInstance();
                UUID uuid = BoomboxItem.getUUID(stack);
                if (uuid != null && !mr.isExistRinger((ServerLevel)level, uuid)) {
                    mr.addRinger((ServerLevel)level, new BoomboxItemRinger(livingEntity, uuid));
                }
            }
            BoomboxData data = BoomboxItem.getData(stack);
            data.tick(level);
            BoomboxItem.setData(stack, data);
            if (livingEntity.m_21205_() == stack || livingEntity.m_21206_() == stack) {
                boolean power = BoomboxItem.isPowerOn(stack);
                BoomboxItem.setTransferProgressOld(stack, BoomboxItem.getTransferProgress(stack));
                BoomboxItem.setTransferProgress(stack, BoomboxItem.getTransferProgress(stack) + (power ? 1 : -1));
            }
        }
    }

    protected boolean m_7274_(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity be;
        BlockEntity blockEntity;
        MinecraftServer server = level.m_142572_();
        if (server != null && (blockEntity = (be = level.m_7702_(blockPos))) instanceof BoomboxBlockEntity) {
            BoomboxBlockEntity boomboxBlockEntity = (BoomboxBlockEntity)blockEntity;
            boomboxBlockEntity.setByItem(itemStack);
            boomboxBlockEntity.m_6596_();
            super.m_7274_(blockPos, level, player, itemStack, blockState);
            return true;
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    public static boolean matches(ItemStack src, ItemStack target) {
        if (src == target) {
            return true;
        }
        UUID uid = BoomboxItem.getUUID(src);
        return uid != null && uid.equals(BoomboxItem.getUUID(target));
    }

    public static CompoundTag getBoomboxTag(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128469_("BoomboxTag");
        }
        return null;
    }

    public static CompoundTag getOrCreateBoomboxTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("BoomboxTag")) {
            tag.m_128365_("BoomboxTag", (Tag)new CompoundTag());
        }
        return tag.m_128469_("BoomboxTag");
    }

    public static BoomboxData getData(final ItemStack stack) {
        BoomboxData data = new BoomboxData(new BoomboxData.DataAccess(){

            @Override
            public ItemStack getCassetteTape() {
                return BoomboxItem.getCassetteTape(stack);
            }

            @Override
            public ItemStack getAntenna() {
                return BoomboxItem.getAntenna(stack);
            }

            @Override
            public boolean isPower() {
                return BoomboxItem.isPowerOn(stack);
            }

            @Override
            public void setPower(boolean power) {
                BoomboxItem.setPowerOn(stack, power);
            }

            @Override
            public IMusicRinger getRinger() {
                UUID uuid = BoomboxItem.getUUID(stack);
                MusicRingManager mr = MusicRingManager.getInstance();
                if (uuid != null) {
                    return mr.getRinger(uuid);
                }
                return null;
            }

            @Override
            public Vec3 getPosition() {
                if (this.getRinger() == null) {
                    return Vec3.f_82478_;
                }
                return this.getRinger().getRingerSpatialPosition();
            }

            @Override
            public void setCassetteTape(ItemStack cassette) {
                BoomboxItem.setCassetteTape(stack, cassette);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                BoomboxItem.setData(stack, data);
            }
        });
        CompoundTag tag = BoomboxItem.getBoomboxTag(stack);
        if (tag != null) {
            data.load(tag.m_128469_("BoomBoxData"), true, true);
        }
        return data;
    }

    public static void setData(ItemStack stack, BoomboxData data) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128365_("BoomBoxData", (Tag)data.save(new CompoundTag(), true, true));
    }

    public static boolean isPowerOn(ItemStack itemStack) {
        if (BoomboxItem.getBoomboxTag(itemStack) != null) {
            return BoomboxItem.getBoomboxTag(itemStack).m_128471_("Power");
        }
        return false;
    }

    public static void setPowerOn(ItemStack itemStack, boolean power) {
        BoomboxItem.getOrCreateBoomboxTag(itemStack).m_128379_("Power", power);
    }

    public static int getTransferProgress(ItemStack stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null) {
            return BoomboxItem.getBoomboxTag(stack).m_128451_("Transfer");
        }
        return 0;
    }

    public static void setTransferProgress(ItemStack stack, int num) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128405_("Transfer", Mth.m_14045_((int)num, (int)0, (int)10));
    }

    public static int getTransferProgressOld(ItemStack stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null) {
            return BoomboxItem.getBoomboxTag(stack).m_128451_("TransferOld");
        }
        return 0;
    }

    public static void setTransferProgressOld(ItemStack stack, int num) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128405_("TransferOld", Mth.m_14045_((int)num, (int)0, (int)10));
    }

    public static float getTransferProgress(ItemStack stack, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)BoomboxItem.getTransferProgressOld(stack), (float)BoomboxItem.getTransferProgress(stack)) / 10.0f;
    }

    public static UUID getUUID(ItemStack stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null && BoomboxItem.getBoomboxTag(stack).m_128441_("Identification")) {
            return BoomboxItem.getBoomboxTag(stack).m_128342_("Identification");
        }
        return null;
    }

    public static void setUUID(ItemStack stack, UUID id) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128362_("Identification", id);
    }

    public static NonNullList<ItemStack> getContainItem(ItemStack stack) {
        NonNullList stacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        ItemContainer.loadItemList((ItemStack)stack, (NonNullList)stacks, (String)"BoomboxItems");
        return stacks;
    }

    public static void setContainItem(ItemStack stack, NonNullList<ItemStack> stacks) {
        ItemContainer.saveItemList((ItemStack)stack, stacks, (String)"BoomboxItems");
    }

    public static void setCassetteTape(ItemStack stack, ItemStack cassette) {
        NonNullList<ItemStack> itms = BoomboxItem.getContainItem(stack);
        itms.set(0, (Object)cassette);
        BoomboxItem.setContainItem(stack, itms);
    }

    public static ItemStack getCassetteTape(ItemStack stack) {
        return (ItemStack)BoomboxItem.getContainItem(stack).get(0);
    }

    public static ItemStack getAntenna(ItemStack stack) {
        return (ItemStack)BoomboxItem.getContainItem(stack).get(1);
    }

    public CompoundTag onInstruction(ItemStack itemStack, ServerPlayer player, String name, int num, CompoundTag data) {
        return BoomboxItem.getData(itemStack).onInstruction(player, name, num, data);
    }

    public static ItemStack createByBE(BoomboxBlockEntity blockEntity, boolean stopMusic) {
        ItemStack itemStack = new ItemStack((ItemLike)IMPBlocks.BOOMBOX);
        BoomboxItem.setContainItem(itemStack, blockEntity.getItems());
        BoomboxItem.setData(itemStack, blockEntity.getBoomboxData());
        BoomboxData d = BoomboxItem.getData(itemStack);
        if (stopMusic) {
            d.setPlaying(false);
            d.setMusicPosition(0L);
        }
        d.setNoChangeCassetteTape(true);
        BoomboxItem.setData(itemStack, d);
        BoomboxItem.setPowerOn(itemStack, blockEntity.isPower());
        if (blockEntity.isPower()) {
            BoomboxItem.setTransferProgress(itemStack, 10);
            BoomboxItem.setTransferProgressOld(itemStack, 10);
        }
        if (blockEntity.m_8077_()) {
            itemStack.m_41714_(blockEntity.m_7770_());
        }
        BoomboxItem.setUUID(itemStack, UUID.randomUUID());
        return itemStack;
    }

    public static boolean checkDuplication(ItemStack stack, Entity entity) {
        UUID stackId = BoomboxItem.getUUID(stack);
        if (stackId == null) {
            return false;
        }
        ArrayList<ItemStack> allItem = new ArrayList<ItemStack>();
        EquipmentSlot[] equipmentSlotArray = entity;
        if (equipmentSlotArray instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)equipmentSlotArray;
            equipmentSlotArray = EquipmentSlot.values();
            int n = equipmentSlotArray.length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot value = equipmentSlotArray[i];
                allItem.add(livingEntity.m_6844_(value));
            }
        }
        if ((equipmentSlotArray = entity) instanceof Player) {
            Player player = (Player)equipmentSlotArray;
            allItem.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
        }
        for (ItemStack item : allItem) {
            if (item == stack || item.m_41619_() || !stackId.equals(BoomboxItem.getUUID(item))) continue;
            return true;
        }
        return false;
    }
}

