/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BoomboxItemRinger
implements IBoomboxRinger {
    private final LivingEntity livingEntity;
    private final UUID uuid;
    private int lastInventory;

    public BoomboxItemRinger(LivingEntity livingEntity, UUID uuid) {
        this.livingEntity = livingEntity;
        this.uuid = uuid;
    }

    @Override
    public Component getRingerName() {
        return new TranslatableComponent("imp.ringer.have", new Object[]{this.getBoombox().m_41611_(), this.livingEntity.m_5446_()});
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel)this.livingEntity.f_19853_;
    }

    @Override
    public UUID getRingerUUID() {
        return this.uuid;
    }

    @Override
    public boolean isRingerExist() {
        return this.livingEntity.m_6084_() && !this.getBoombox().m_41619_();
    }

    @Override
    public Pair<ResourceLocation, CompoundTag> getRingerTracker() {
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return Pair.of((Object)MusicRingManager.PLAYER_TRACKER, (Object)MusicRingManager.createPlayerTracker(player));
        }
        return Pair.of((Object)MusicRingManager.ENTITY_TRACKER, (Object)MusicRingManager.createEntityTracker((Entity)this.livingEntity));
    }

    @Override
    @NotNull
    public Vec3 getRingerSpatialPosition() {
        return this.livingEntity.m_20182_();
    }

    @NotNull
    private ItemStack getBoombox() {
        for (EquipmentSlot value : EquipmentSlot.values()) {
            ItemStack item = this.livingEntity.m_6844_(value);
            if (!this.uuid.equals(BoomboxItem.getUUID(item))) continue;
            return item;
        }
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack li = player.m_150109_().m_8020_(this.lastInventory);
            if (this.uuid.equals(BoomboxItem.getUUID(li))) {
                return li;
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack item = player.m_150109_().m_8020_(i);
                if (!this.uuid.equals(BoomboxItem.getUUID(item))) continue;
                this.lastInventory = i;
                return item;
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public BoomboxData getRingerBoomboxData() {
        return BoomboxItem.getData(this.getBoombox());
    }
}

