/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.alibaba.fastjson.support.spring;

import dev.felnull.imp.libs.com.alibaba.fastjson.JSON;
import dev.felnull.imp.libs.com.alibaba.fastjson.parser.Feature;
import dev.felnull.imp.libs.com.alibaba.fastjson.parser.ParserConfig;
import dev.felnull.imp.libs.com.alibaba.fastjson.serializer.SerializerFeature;
import dev.felnull.imp.libs.com.alibaba.fastjson.util.IOUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class GenericFastJsonRedisSerializer
implements RedisSerializer<Object> {
    private static final ParserConfig defaultRedisConfig = new ParserConfig();

    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONBytes(object, SerializerFeature.WriteClassName);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return JSON.parseObject(new String(bytes, IOUtils.UTF8), Object.class, defaultRedisConfig, new Feature[0]);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    static {
        defaultRedisConfig.setAutoTypeSupport(true);
    }
}

