/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.frame;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacStreamInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacFrameInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.BitStreamReader;
import java.io.IOException;

public class FlacFrameHeaderReader {
    private static final int VALUE_INVALID = Integer.MIN_VALUE;
    private static final int VALUE_INHERITED = -1024;
    private static final int BLOCK_SIZE_EXPLICIT_8_BIT = -2;
    private static final int BLOCK_SIZE_EXPLICIT_16_BIT = -1;
    private static final int SAMPLE_RATE_EXPLICIT_8_BIT = -3;
    private static final int SAMPLE_RATE_EXPLICIT_16_BIT = -2;
    private static final int SAMPLE_RATE_EXPLICIT_10X_16_BIT = -1;
    private static final int[] blockSizeMapping = new int[]{Integer.MIN_VALUE, 192, 576, 1152, 2304, 4608, -2, -1, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    private static final int[] sampleRateMapping = new int[]{-1024, 88200, 176400, 192000, 8000, 16000, 22050, 24000, 32000, 44100, 48000, 96000, -3, -2, -1, Integer.MIN_VALUE};
    private static final int[] channelCountMapping = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 2, 2, 2, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    private static final FlacFrameInfo.ChannelDelta[] channelDeltaMapping = new FlacFrameInfo.ChannelDelta[]{FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.LEFT_SIDE, FlacFrameInfo.ChannelDelta.RIGHT_SIDE, FlacFrameInfo.ChannelDelta.MID_SIDE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE, FlacFrameInfo.ChannelDelta.NONE};
    private static final int[] sampleSizeMapping = new int[]{-1024, 8, 12, Integer.MIN_VALUE, 16, 20, 24, Integer.MIN_VALUE};

    public static FlacFrameInfo readFrameHeader(BitStreamReader bitStreamReader, FlacStreamInfo streamInfo, boolean variableBlock) throws IOException {
        int blockSize = blockSizeMapping[bitStreamReader.asInteger(4)];
        int sampleRate = sampleRateMapping[bitStreamReader.asInteger(4)];
        int channelAssignment = bitStreamReader.asInteger(4);
        int channelCount = channelCountMapping[channelAssignment];
        FlacFrameInfo.ChannelDelta channelDelta = channelDeltaMapping[channelAssignment];
        int sampleSize = sampleSizeMapping[bitStreamReader.asInteger(3)];
        bitStreamReader.asInteger(1);
        FlacFrameHeaderReader.readUtf8Value(variableBlock, bitStreamReader);
        if (blockSize == -2) {
            blockSize = bitStreamReader.asInteger(8) + 1;
        } else if (blockSize == -1) {
            blockSize = bitStreamReader.asInteger(16) + 1;
        }
        FlacFrameHeaderReader.verifyNotInvalid(blockSize, "block size");
        if (blockSize == -3) {
            sampleRate = bitStreamReader.asInteger(8);
        } else if (blockSize == -2) {
            sampleRate = bitStreamReader.asInteger(16);
        } else if (blockSize == -1) {
            sampleRate = bitStreamReader.asInteger(16) * 10;
        }
        FlacFrameHeaderReader.verifyMatchesExpected(sampleRate, streamInfo.sampleRate, "sample rate");
        FlacFrameHeaderReader.verifyMatchesExpected(channelCount, streamInfo.channelCount, "channel count");
        FlacFrameHeaderReader.verifyMatchesExpected(sampleSize, streamInfo.bitsPerSample, "bits per sample");
        bitStreamReader.asInteger(8);
        return new FlacFrameInfo(blockSize, channelDelta);
    }

    private static void verifyNotInvalid(int value, String description) {
        if (value < 0) {
            throw new IllegalStateException("Invalid value " + value + " for " + description);
        }
    }

    private static void verifyMatchesExpected(int value, int expected, String description) {
        if (value != -1024 && value != expected) {
            throw new IllegalStateException("Invalid value " + value + " for " + description + ", should match value " + expected + " in stream.");
        }
    }

    private static long readUtf8Value(boolean isLong, BitStreamReader bitStreamReader) throws IOException {
        int maximumSize = isLong ? 7 : 6;
        int firstByte = bitStreamReader.asInteger(8);
        int leadingOnes = Integer.numberOfLeadingZeros(~firstByte & 0xFF) - 24;
        if (leadingOnes > maximumSize || leadingOnes == 1) {
            throw new IllegalStateException("Invalid number of leading ones in UTF encoded integer");
        }
        if (leadingOnes == 0) {
            return firstByte;
        }
        long value = (long)firstByte - (1L << 7 - leadingOnes) - 1L;
        for (int i = 0; i < leadingOnes - 1; ++i) {
            int currentByte = bitStreamReader.asInteger(8);
            if ((currentByte & 0xC0) != 128) {
                throw new IllegalStateException("Invalid content of payload byte, first bits must be 1 and 0.");
            }
            value = value << 6 | (long)(currentByte & 0x3F);
        }
        return value;
    }
}

