/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.common.AacPacketRouter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAacTrackConsumer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaAacTrackConsumer
implements MatroskaTrackConsumer {
    private static final Logger log = LoggerFactory.getLogger(MpegAacTrackConsumer.class);
    private final MatroskaFileTrack track;
    private final ByteBuffer inputBuffer;
    private final AacPacketRouter packetRouter;

    public MatroskaAacTrackConsumer(AudioProcessingContext context, MatroskaFileTrack track) {
        this.track = track;
        this.inputBuffer = ByteBuffer.allocateDirect(4096);
        this.packetRouter = new AacPacketRouter(context, this::configureDecoder);
    }

    @Override
    public void initialise() {
        log.debug("Initialising AAC track with expected frequency {} and channel count {}.", (Object)Float.valueOf(this.track.audio.samplingFrequency), (Object)this.track.audio.channels);
    }

    @Override
    public MatroskaFileTrack getTrack() {
        return this.track;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.packetRouter.seekPerformed(requestedTimecode, providedTimecode);
    }

    @Override
    public void flush() throws InterruptedException {
        this.packetRouter.flush();
    }

    @Override
    public void consume(ByteBuffer data) throws InterruptedException {
        while (data.hasRemaining()) {
            int chunk = Math.min(data.remaining(), this.inputBuffer.capacity());
            ByteBuffer chunkBuffer = data.duplicate();
            chunkBuffer.limit(chunkBuffer.position() + chunk);
            this.inputBuffer.clear();
            this.inputBuffer.put(chunkBuffer);
            this.inputBuffer.flip();
            this.packetRouter.processInput(this.inputBuffer);
            data.position(chunkBuffer.position());
        }
    }

    @Override
    public void close() {
        this.packetRouter.close();
    }

    private void configureDecoder(AacDecoder decoder) {
        decoder.configure(this.track.codecPrivate);
    }
}

