/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.ogg.vorbis;

import com.sedmelluq.discord.lavaplayer.natives.vorbis.VorbisDecoder;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OggVorbisTrackHandler
implements OggTrackHandler {
    private static final int PCM_BUFFER_SIZE = 4096;
    private final byte[] infoPacket;
    private final OggPacketInputStream packetInputStream;
    private final DirectBufferStreamBroker broker;
    private final VorbisDecoder decoder;
    private final int sampleRate;
    private float[][] channelPcmBuffers;
    private AudioPipeline downstream;

    public OggVorbisTrackHandler(byte[] infoPacket, OggPacketInputStream packetInputStream, DirectBufferStreamBroker broker) {
        this.infoPacket = infoPacket;
        this.packetInputStream = packetInputStream;
        this.broker = broker;
        this.decoder = new VorbisDecoder();
        ByteBuffer infoBuffer = ByteBuffer.wrap(infoPacket);
        this.sampleRate = Integer.reverseBytes(infoBuffer.getInt(12));
        int channelCount = infoBuffer.get(11) & 0xFF;
        this.channelPcmBuffers = new float[channelCount][];
        for (int i = 0; i < this.channelPcmBuffers.length; ++i) {
            this.channelPcmBuffers[i] = new float[4096];
        }
    }

    @Override
    public void initialise(AudioProcessingContext context, long timecode, long desiredTimecode) throws IOException {
        ByteBuffer infoBuffer = ByteBuffer.allocateDirect(this.infoPacket.length);
        infoBuffer.put(this.infoPacket);
        infoBuffer.flip();
        if (!this.packetInputStream.startNewPacket()) {
            throw new IllegalStateException("End of track before header setup header.");
        }
        this.broker.consumeNext(this.packetInputStream, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.decoder.initialise(infoBuffer, this.broker.getBuffer());
        this.broker.resetAndCompact();
        this.downstream = AudioPipelineFactory.create(context, new PcmFormat(this.decoder.getChannelCount(), this.sampleRate));
        this.downstream.seekPerformed(desiredTimecode, timecode);
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try {
            while (this.packetInputStream.startNewPacket()) {
                this.broker.consumeNext(this.packetInputStream, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.provideFromBuffer(this.broker.getBuffer());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void provideFromBuffer(ByteBuffer buffer) throws InterruptedException {
        int output;
        this.decoder.input(buffer);
        do {
            if ((output = this.decoder.output(this.channelPcmBuffers)) <= 0) continue;
            this.downstream.process(this.channelPcmBuffers, 0, output);
        } while (output == 4096);
    }

    @Override
    public void seekToTimecode(long timecode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.downstream != null) {
            this.downstream.close();
        }
        this.decoder.close();
    }
}

