/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeAudioFilter
implements UniversalPcmAudioFilter {
    private static final Logger log = LoggerFactory.getLogger(CompositeAudioFilter.class);

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        for (AudioFilter filter : this.getFilters()) {
            try {
                filter.seekPerformed(requestedTime, providedTime);
            }
            catch (Exception e) {
                log.error("Notifying filter {} of seek failed with exception.", filter.getClass(), (Object)e);
            }
        }
    }

    @Override
    public void flush() throws InterruptedException {
        for (AudioFilter filter : this.getFilters()) {
            try {
                filter.flush();
            }
            catch (Exception e) {
                log.error("Flushing filter {} failed with exception.", filter.getClass(), (Object)e);
            }
        }
    }

    @Override
    public void close() {
        for (AudioFilter filter : this.getFilters()) {
            try {
                filter.close();
            }
            catch (Exception e) {
                log.error("Closing filter {} failed with exception.", filter.getClass(), (Object)e);
            }
        }
    }

    protected abstract List<AudioFilter> getFilters();
}

