/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.function.Consumer;

public class FunctionalResultHandler
implements AudioLoadResultHandler {
    private final Consumer<AudioTrack> trackConsumer;
    private final Consumer<AudioPlaylist> playlistConsumer;
    private final Runnable emptyResultHandler;
    private final Consumer<FriendlyException> exceptionConsumer;

    public FunctionalResultHandler(Consumer<AudioTrack> trackConsumer, Consumer<AudioPlaylist> playlistConsumer, Runnable emptyResultHandler, Consumer<FriendlyException> exceptionConsumer) {
        this.trackConsumer = trackConsumer;
        this.playlistConsumer = playlistConsumer;
        this.emptyResultHandler = emptyResultHandler;
        this.exceptionConsumer = exceptionConsumer;
    }

    @Override
    public void trackLoaded(AudioTrack track) {
        if (this.trackConsumer != null) {
            this.trackConsumer.accept(track);
        }
    }

    @Override
    public void playlistLoaded(AudioPlaylist playlist) {
        if (this.playlistConsumer != null) {
            this.playlistConsumer.accept(playlist);
        }
    }

    @Override
    public void noMatches() {
        if (this.emptyResultHandler != null) {
            this.emptyResultHandler.run();
        }
    }

    @Override
    public void loadFailed(FriendlyException exception) {
        if (this.exceptionConsumer != null) {
            this.exceptionConsumer.accept(exception);
        }
    }
}

