/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.stream;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpUriRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public abstract class M3uStreamSegmentUrlProvider {
    private static final long SEGMENT_WAIT_STEP_MS = 200L;
    protected SegmentInfo lastSegment;

    protected static String createSegmentUrl(String playlistUrl, String segmentName) {
        return URI.create(playlistUrl).resolve(segmentName).toString();
    }

    protected abstract String getQualityFromM3uDirective(ExtendedM3uParser.Line var1);

    protected abstract String fetchSegmentPlaylistUrl(HttpInterface var1) throws IOException;

    protected String getNextSegmentUrl(HttpInterface httpInterface) {
        try {
            List<SegmentInfo> segments;
            SegmentInfo nextSegment;
            String streamSegmentPlaylistUrl = this.fetchSegmentPlaylistUrl(httpInterface);
            if (streamSegmentPlaylistUrl == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            while ((nextSegment = this.chooseNextSegment(segments = this.loadStreamSegmentsList(httpInterface, streamSegmentPlaylistUrl), this.lastSegment)) == null && this.shouldWaitForSegment(startTime, segments)) {
                Thread.sleep(200L);
            }
            if (nextSegment == null) {
                return null;
            }
            this.lastSegment = nextSegment;
            return M3uStreamSegmentUrlProvider.createSegmentUrl(streamSegmentPlaylistUrl, this.lastSegment.url);
        }
        catch (IOException e) {
            throw new FriendlyException("Failed to get next part of the stream.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getNextSegmentStream(HttpInterface httpInterface) {
        String url = this.getNextSegmentUrl(httpInterface);
        if (url == null) {
            return null;
        }
        CloseableHttpResponse response = null;
        boolean success = false;
        try {
            response = httpInterface.execute(this.createSegmentGetRequest(url));
            HttpClientTools.assertSuccessWithContent(response, "segment data URL");
            success = true;
            InputStream inputStream = response.getEntity().getContent();
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (response != null && !success) {
                ExceptionTools.closeWithWarnings(response);
            }
        }
    }

    protected abstract HttpUriRequest createSegmentGetRequest(String var1);

    protected List<ChannelStreamInfo> loadChannelStreamsList(String[] lines) {
        ExtendedM3uParser.Line streamInfoLine = null;
        ArrayList<ChannelStreamInfo> streams = new ArrayList<ChannelStreamInfo>();
        for (String lineText : lines) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isData() && streamInfoLine != null) {
                String quality = this.getQualityFromM3uDirective(streamInfoLine);
                if (quality != null) {
                    streams.add(new ChannelStreamInfo(quality, line.lineData));
                }
                streamInfoLine = null;
                continue;
            }
            if (!line.isDirective() || !"EXT-X-STREAM-INF".equals(line.directiveName)) continue;
            streamInfoLine = line;
        }
        return streams;
    }

    protected List<SegmentInfo> loadStreamSegmentsList(HttpInterface httpInterface, String streamSegmentPlaylistUrl) throws IOException {
        ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
        ExtendedM3uParser.Line segmentInfo = null;
        for (String lineText : HttpClientTools.fetchResponseLines(httpInterface, new HttpGet(streamSegmentPlaylistUrl), "stream segments list")) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isDirective() && "EXTINF".equals(line.directiveName)) {
                segmentInfo = line;
            }
            if (!line.isData()) continue;
            if (segmentInfo != null && segmentInfo.extraData.contains(",")) {
                String[] fields = segmentInfo.extraData.split(",", 2);
                segments.add(new SegmentInfo(line.lineData, M3uStreamSegmentUrlProvider.parseSecondDuration(fields[0]), fields[1]));
                continue;
            }
            segments.add(new SegmentInfo(line.lineData, null, null));
        }
        return segments;
    }

    private static Long parseSecondDuration(String value) {
        try {
            double asDouble = Double.parseDouble(value);
            return (long)(asDouble * 1000.0);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    protected SegmentInfo chooseNextSegment(List<SegmentInfo> segments, SegmentInfo lastSegment) {
        SegmentInfo selected = null;
        for (int i = segments.size() - 1; i >= 0; --i) {
            SegmentInfo current = segments.get(i);
            if (lastSegment != null && current.url.equals(lastSegment.url)) break;
            selected = current;
        }
        return selected;
    }

    private boolean shouldWaitForSegment(long startTime, List<SegmentInfo> segments) {
        if (!segments.isEmpty()) {
            SegmentInfo sampleSegment = segments.get(0);
            if (sampleSegment.duration != null) {
                return System.currentTimeMillis() - startTime < sampleSegment.duration;
            }
        }
        return false;
    }

    protected static class SegmentInfo {
        public final String url;
        public final Long duration;
        public final String name;

        public SegmentInfo(String url, Long duration, String name) {
            this.url = url;
            this.duration = duration;
            this.name = name;
        }
    }

    protected static class ChannelStreamInfo {
        public final String quality;
        public final String url;

        private ChannelStreamInfo(String quality, String url) {
            this.quality = quality;
            this.url = url;
        }
    }
}

