/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.twitch;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.libs.org.apache.http.client.utils.URIBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchStreamSegmentUrlProvider
extends M3uStreamSegmentUrlProvider {
    private static final String TOKEN_PARAMETER = "token";
    private static final Logger log = LoggerFactory.getLogger(TwitchStreamSegmentUrlProvider.class);
    private final String channelName;
    private final TwitchStreamAudioSourceManager manager;
    private String streamSegmentPlaylistUrl;
    private long tokenExpirationTime;

    public TwitchStreamSegmentUrlProvider(String channelName, TwitchStreamAudioSourceManager manager) {
        this.channelName = channelName;
        this.manager = manager;
        this.tokenExpirationTime = -1L;
    }

    @Override
    protected String getQualityFromM3uDirective(ExtendedM3uParser.Line directiveLine) {
        return directiveLine.directiveArguments.get("VIDEO");
    }

    @Override
    protected String fetchSegmentPlaylistUrl(HttpInterface httpInterface) throws IOException {
        if (System.currentTimeMillis() < this.tokenExpirationTime) {
            return this.streamSegmentPlaylistUrl;
        }
        JsonBrowser token = this.loadAccessToken(httpInterface);
        HttpGet request = new HttpGet(this.getChannelStreamsUrl(token).toString());
        ChannelStreams streams = this.loadChannelStreamsInfo(HttpClientTools.fetchResponseLines(httpInterface, request, "channel streams list"));
        if (streams.entries.isEmpty()) {
            throw new IllegalStateException("No streams available on channel.");
        }
        M3uStreamSegmentUrlProvider.ChannelStreamInfo stream = (M3uStreamSegmentUrlProvider.ChannelStreamInfo)streams.entries.get(0);
        log.debug("Chose stream with quality {} from url {}", (Object)stream.quality, (Object)stream.url);
        this.streamSegmentPlaylistUrl = stream.url;
        long tokenServerExpirationTime = JsonBrowser.parse(token.get(TOKEN_PARAMETER).text()).get("expires").as(Long.class) * 1000L;
        this.tokenExpirationTime = System.currentTimeMillis() + (tokenServerExpirationTime - streams.serverTime) - 5000L;
        return this.streamSegmentPlaylistUrl;
    }

    @Override
    protected HttpUriRequest createSegmentGetRequest(String url) {
        return this.manager.createGetRequest(url);
    }

    private JsonBrowser loadAccessToken(HttpInterface httpInterface) throws IOException {
        HttpUriRequest request = this.createSegmentGetRequest("https://api.twitch.tv/api/channels/" + this.channelName + "/access_token?oauth_token=undefined&need_https=true&player_type=site&player_backend=mediaplayer");
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Unexpected response code from access token request: " + statusCode);
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    private ChannelStreams loadChannelStreamsInfo(String[] lines) {
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = this.loadChannelStreamsList(lines);
        ExtendedM3uParser.Line twitchInfoLine = null;
        for (String lineText : lines) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (!line.isDirective() || !"EXT-X-TWITCH-INFO".equals(line.directiveName)) continue;
            twitchInfoLine = line;
        }
        return this.buildChannelStreamsInfo(twitchInfoLine, streams);
    }

    private ChannelStreams buildChannelStreamsInfo(ExtendedM3uParser.Line twitchInfoLine, List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams) {
        String serverTimeValue;
        String string = serverTimeValue = twitchInfoLine != null ? twitchInfoLine.directiveArguments.get("SERVER-TIME") : null;
        if (serverTimeValue == null) {
            throw new IllegalStateException("Required server time information not available.");
        }
        return new ChannelStreams((long)(Double.parseDouble(serverTimeValue) * 1000.0), streams);
    }

    private URI getChannelStreamsUrl(JsonBrowser token) {
        try {
            return new URIBuilder("https://usher.ttvnw.net/api/channel/hls/" + this.channelName + ".m3u8").addParameter(TOKEN_PARAMETER, token.get(TOKEN_PARAMETER).text()).addParameter("sig", token.get("sig").text()).addParameter("allow_source", "true").addParameter("allow_spectre", "true").addParameter("player_backend", "html5").addParameter("expgroup", "regular").build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ChannelStreams {
        private final long serverTime;
        private final List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> entries;

        private ChannelStreams(long serverTime, List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> entries) {
            this.serverTime = serverTime;
            this.entries = entries;
        }
    }
}

