/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.libs.org.apache.http.entity.ContentType;

public enum YoutubeFormatInfo {
    WEBM_OPUS("audio/webm", "opus"),
    WEBM_VORBIS("audio/webm", "vorbis"),
    MP4_AAC_LC("audio/mp4", "mp4a.40.2"),
    WEBM_VIDEO_VORBIS("video/webm", "vorbis"),
    MP4_VIDEO_AAC_LC("video/mp4", "mp4a.40.2");

    public final String mimeType;
    public final String codec;

    private YoutubeFormatInfo(String mimeType, String codec) {
        this.mimeType = mimeType;
        this.codec = codec;
    }

    public static YoutubeFormatInfo get(ContentType contentType) {
        String mimeType = contentType.getMimeType();
        String codec = contentType.getParameter("codecs");
        for (YoutubeFormatInfo formatInfo : (YoutubeFormatInfo[])YoutubeFormatInfo.class.getEnumConstants()) {
            if (!formatInfo.mimeType.equals(mimeType) || !formatInfo.codec.equals(codec)) continue;
            return formatInfo;
        }
        for (YoutubeFormatInfo formatInfo : (YoutubeFormatInfo[])YoutubeFormatInfo.class.getEnumConstants()) {
            if (!formatInfo.mimeType.equals(mimeType) || !codec.contains(formatInfo.codec)) continue;
            return formatInfo;
        }
        return null;
    }
}

