/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionMonitor
implements NotificationListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectionMonitor.class);
    private static final long REPORTING_FREQUENCY = TimeUnit.MINUTES.toMillis(2L);
    private static final long[] BUCKETS = new long[]{2000L, 500L, 200L, 50L, 20L, 0L};
    private final ScheduledExecutorService reportingExecutor;
    private final int[] bucketCounters;
    private final AtomicBoolean enabled;
    private final AtomicReference<ScheduledFuture<?>> executorFuture;

    public GarbageCollectionMonitor(ScheduledExecutorService reportingExecutor) {
        this.reportingExecutor = reportingExecutor;
        this.bucketCounters = new int[BUCKETS.length];
        this.enabled = new AtomicBoolean();
        this.executorFuture = new AtomicReference();
    }

    public void enable() {
        if (this.enabled.compareAndSet(false, true)) {
            this.registerBeanListener();
            this.executorFuture.set(this.reportingExecutor.scheduleAtFixedRate(this, REPORTING_FREQUENCY, REPORTING_FREQUENCY, TimeUnit.MILLISECONDS));
            log.info("GC monitoring enabled, reporting results every 2 minutes.");
        }
    }

    public void disable() {
        if (this.enabled.compareAndSet(true, false)) {
            this.unregisterBeanListener();
            ScheduledFuture scheduledTask = this.executorFuture.getAndSet(null);
            if (scheduledTask != null) {
                scheduledTask.cancel(false);
            }
            log.info("GC monitoring disabled.");
        }
    }

    private void registerBeanListener() {
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)gcBean)).addNotificationListener(this, null, gcBean);
        }
    }

    private void unregisterBeanListener() {
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            try {
                ((NotificationEmitter)((Object)gcBean)).removeNotificationListener(this);
            }
            catch (ListenerNotFoundException e) {
                log.debug("No listener found on bean {}, should have been there.", (Object)gcBean, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPause(long duration) {
        int[] nArray = this.bucketCounters;
        synchronized (this.bucketCounters) {
            for (int i = 0; i < this.bucketCounters.length; ++i) {
                if (duration < BUCKETS[i]) continue;
                int n = i;
                this.bucketCounters[n] = this.bucketCounters[n] + 1;
                break;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        GarbageCollectionNotificationInfo notificationInfo;
        GcInfo info;
        if ("com.sun.management.gc.notification".equals(notification.getType()) && (info = (notificationInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData())).getGcInfo()) != null && !"No GC".equals(notificationInfo.getGcCause())) {
            this.registerPause(info.getDuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder statistics = new StringBuilder();
        int[] nArray = this.bucketCounters;
        synchronized (this.bucketCounters) {
            boolean hasBadLatency = this.bucketCounters[0] + this.bucketCounters[1] + this.bucketCounters[2] > 0;
            for (int i = this.bucketCounters.length - 1; i >= 0; --i) {
                statistics.append(String.format("[Bucket %d = %d] ", BUCKETS[i], this.bucketCounters[i]));
                this.bucketCounters[i] = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (hasBadLatency) {
                log.warn("Suspicious GC results for the last 2 minutes: {}", (Object)statistics);
            } else {
                log.debug("GC results for the last 2 minutes: {}", (Object)statistics);
            }
            return;
        }
    }
}

