/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import dev.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.libs.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.libs.org.apache.http.impl.client.CloseableHttpClient;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class HttpInterface
implements Closeable {
    private final CloseableHttpClient client;
    private final HttpClientContext context;
    private final boolean ownedClient;
    private final HttpContextFilter filter;
    private HttpUriRequest lastRequest;
    private boolean available;

    public HttpInterface(CloseableHttpClient client, HttpClientContext context, boolean ownedClient, HttpContextFilter filter) {
        this.client = client;
        this.context = context;
        this.ownedClient = ownedClient;
        this.filter = filter;
        this.available = true;
    }

    public boolean acquire() {
        if (!this.available) {
            return false;
        }
        this.filter.onContextOpen(this.context);
        this.available = false;
        return true;
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        boolean isRepeated = false;
        while (true) {
            this.filter.onRequest(this.context, request, isRepeated);
            try {
                CloseableHttpResponse response = this.client.execute(request, this.context);
                this.lastRequest = request;
                if (!this.filter.onRequestResponse(this.context, request, response)) {
                    return response;
                }
            }
            catch (Throwable e) {
                if (!this.filter.onRequestException(this.context, request, e)) {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new RuntimeException(e);
                }
                ExceptionTools.rethrowErrors(e);
            }
            isRepeated = true;
        }
    }

    public URI getFinalLocation() {
        List<URI> redirectLocations = this.context.getRedirectLocations();
        if (redirectLocations != null && !redirectLocations.isEmpty()) {
            return redirectLocations.get(redirectLocations.size() - 1);
        }
        return this.lastRequest != null ? this.lastRequest.getURI() : null;
    }

    public HttpClientContext getContext() {
        return this.context;
    }

    public CloseableHttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        this.available = true;
        this.filter.onContextClose(this.context);
        if (this.ownedClient) {
            this.client.close();
        }
    }
}

