/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.lava.common.tools;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorTools {
    private static final Logger log = LoggerFactory.getLogger(ExecutorTools.class);
    private static final long WAIT_TIME = 1000L;
    public static final CompletedVoidFuture COMPLETED_VOID = new CompletedVoidFuture();

    public static void shutdownExecutor(ExecutorService executorService, String description) {
        if (executorService == null) {
            return;
        }
        log.debug("Shutting down executor {}", (Object)description);
        executorService.shutdownNow();
        try {
            if (!executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                log.debug("Executor {} did not shut down in {}", (Object)description, (Object)1000L);
            } else {
                log.debug("Executor {} successfully shut down", (Object)description);
            }
        }
        catch (InterruptedException e) {
            log.debug("Received an interruption while shutting down executor {}", (Object)description);
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadPoolExecutor createEagerlyScalingExecutor(int coreSize, int maximumSize, long timeout, int queueCapacity, ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, maximumSize, timeout, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new EagerlyScalingTaskQueue(queueCapacity), threadFactory);
        executor.setRejectedExecutionHandler(new EagerlyScalingRejectionHandler());
        return executor;
    }

    private static class CompletedVoidFuture
    implements Future<Void> {
        private CompletedVoidFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }

    private static class EagerlyScalingRejectionHandler
    implements RejectedExecutionHandler {
        private EagerlyScalingRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (!((EagerlyScalingTaskQueue)executor.getQueue()).offerDirectly(runnable)) {
                throw new RejectedExecutionException("Task " + runnable.toString() + " rejected from " + runnable.toString());
            }
        }
    }

    private static class EagerlyScalingTaskQueue
    extends LinkedBlockingQueue<Runnable> {
        public EagerlyScalingTaskQueue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(Runnable runnable) {
            return this.isEmpty() && super.offer(runnable);
        }

        public boolean offerDirectly(Runnable runnable) {
            return super.offer(runnable);
        }
    }
}

