/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.dev.felnull.fnjl;

import dev.felnull.imp.libs.dev.felnull.fnjl.util.FNStringUtil;
import java.util.function.Consumer;
import java.util.function.Function;

public class ProgressLogger {
    private int size;
    private int complete;
    private int total;
    private BarType barType;
    private Consumer<String> logger = n -> System.out.print(n + "\r");
    private Function<ProgressLogger, String> startStr = n -> FNStringUtil.getPercentage(n.complete, n.total) + " ";
    private Function<ProgressLogger, String> endStr = n -> " " + n.getComplete() + "/" + n.getTotal();

    public ProgressLogger(int size, int total, BarType barType) {
        this(size, 0, total, barType);
    }

    public ProgressLogger(int size, int complete, int total, BarType barType) {
        this.size = size;
        this.complete = complete;
        this.total = total;
        this.barType = barType;
    }

    public BarType getBarType() {
        return this.barType;
    }

    public void setBarType(BarType barType) {
        this.barType = barType;
    }

    public int getComplete() {
        return this.complete;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotal() {
        return this.total;
    }

    public void setLogger(Consumer<String> logger) {
        this.logger = logger;
    }

    public void setComplete(int complete) {
        this.complete = complete;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getProgressBar(int complete) {
        this.setComplete(complete);
        return this.getProgressBar();
    }

    public String getProgressBar() {
        int i;
        StringBuilder sb = new StringBuilder();
        float b = (float)this.complete / (float)this.total;
        int ct = (int)((float)this.size * b);
        for (i = 0; i < ct; ++i) {
            if (i == ct - 1) {
                sb.append(this.barType.getTip());
                break;
            }
            sb.append(this.barType.getFill());
        }
        for (i = 0; i < this.size - ct; ++i) {
            sb.append(this.barType.getEmpty());
        }
        return sb.toString();
    }

    public void printProgress(int complete) {
        this.setComplete(complete);
        this.printProgress();
    }

    public void setEndStr(Function<ProgressLogger, String> endStr) {
        this.endStr = endStr;
    }

    public void setStartStr(Function<ProgressLogger, String> startStr) {
        this.startStr = startStr;
    }

    public void printProgress() {
        this.logger.accept((this.startStr != null ? this.startStr.apply(this) : "") + this.barType.getStart() + this.getProgressBar() + this.barType.getEnd() + (this.endStr != null ? this.endStr.apply(this) : ""));
    }

    public static enum BarType {
        CUBE("\u25a0", "\u25a1", "\u25a0", "", ""),
        ARROW(">", " ", "=", "[", "]"),
        SHARP("#", " ", "#", "[", "]");

        private final String tip;
        private final String empty;
        private final String fill;
        private final String start;
        private final String end;

        private BarType(String tip, String empty, String fill, String start, String end) {
            this.tip = tip;
            this.empty = empty;
            this.fill = fill;
            this.start = start;
            this.end = end;
        }

        public String getEmpty() {
            return this.empty;
        }

        public String getFill() {
            return this.fill;
        }

        public String getTip() {
            return this.tip;
        }

        public String getEnd() {
            return this.end;
        }

        public String getStart() {
            return this.start;
        }
    }
}

