/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.org.apache.http.client.protocol;

import dev.felnull.imp.libs.org.apache.http.Header;
import dev.felnull.imp.libs.org.apache.http.HttpException;
import dev.felnull.imp.libs.org.apache.http.HttpRequest;
import dev.felnull.imp.libs.org.apache.http.HttpRequestInterceptor;
import dev.felnull.imp.libs.org.apache.http.annotation.Contract;
import dev.felnull.imp.libs.org.apache.http.annotation.ThreadingBehavior;
import dev.felnull.imp.libs.org.apache.http.protocol.HttpContext;
import dev.felnull.imp.libs.org.apache.http.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

