/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music;

import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class MusicPlaybackInfo
implements ITAGSerializable {
    public static final MusicPlaybackInfo EMPTY = new MusicPlaybackInfo(new ResourceLocation("empty"), new CompoundTag(), 0.0f, 0.0f);
    private ResourceLocation tracker;
    private CompoundTag trackerTag;
    private float volume;
    private float range;

    public MusicPlaybackInfo() {
    }

    public MusicPlaybackInfo(ResourceLocation tracker, CompoundTag trackerTag, float volume, float range) {
        this.tracker = tracker;
        this.trackerTag = trackerTag;
        this.volume = volume;
        this.range = range;
    }

    public CompoundTag getTrackerTag() {
        return this.trackerTag;
    }

    public ResourceLocation getTracker() {
        return this.tracker;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getRange() {
        return this.range;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("TrackerID", this.tracker.toString());
        tag.m_128365_("TrackerTag", (Tag)this.trackerTag);
        tag.m_128350_("Volume", this.volume);
        tag.m_128350_("Range", this.range);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.tracker = new ResourceLocation(tag.m_128461_("TrackerID"));
        this.trackerTag = tag.m_128469_("TrackerTag");
        this.volume = tag.m_128457_("Volume");
        this.range = tag.m_128457_("Range");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MusicPlaybackInfo that = (MusicPlaybackInfo)o;
        return Float.compare(that.volume, this.volume) == 0 && Float.compare(that.range, this.range) == 0 && Objects.equals(this.tracker, that.tracker) && Objects.equals(this.trackerTag, that.trackerTag);
    }

    public int hashCode() {
        return Objects.hash(this.tracker, this.trackerTag, Float.valueOf(this.volume), Float.valueOf(this.range));
    }

    public String toString() {
        return "MusicPlaybackInfo{tracker=" + this.tracker + ", trackerTag=" + this.trackerTag + ", volume=" + this.volume + ", range=" + this.range + "}";
    }
}

