/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class AuthorityInfo
implements ITAGSerializable {
    private boolean publiced;
    private UUID owner;
    private String ownerName;
    private Map<UUID, AuthorityType> authority = new HashMap<UUID, AuthorityType>();
    private AuthorityType initialAuthority;

    public AuthorityInfo() {
    }

    public AuthorityInfo(boolean publiced, UUID owner, String ownerName, AuthorityType initialAuthority) {
        this(publiced, owner, ownerName, new HashMap<UUID, AuthorityType>(), initialAuthority);
    }

    public AuthorityInfo(boolean publiced, UUID owner, String ownerName, Map<UUID, AuthorityType> authority, AuthorityType initialAuthority) {
        this.publiced = publiced;
        this.owner = owner;
        this.authority = authority;
        this.ownerName = ownerName;
        this.initialAuthority = initialAuthority;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128379_("Public", this.publiced);
        tag.m_128362_("Owner", this.owner);
        IMPNbtUtil.writeAuthority(tag, "Authority", this.authority);
        tag.m_128359_("OwnerName", this.ownerName);
        tag.m_128359_("InitialAuthority", this.initialAuthority.getName());
        return tag;
    }

    public void load(CompoundTag tag) {
        this.publiced = tag.m_128471_("Public");
        this.owner = tag.m_128342_("Owner");
        IMPNbtUtil.readAuthority(tag, "Authority", this.authority);
        this.ownerName = tag.m_128461_("OwnerName");
        this.initialAuthority = AuthorityType.getByName(tag.m_128461_("InitialAuthority"));
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isPublic() {
        return this.publiced;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Map<UUID, AuthorityType> getRawAuthority() {
        return this.authority;
    }

    @NotNull
    public AuthorityType getAuthorityType(@NotNull UUID playerId) {
        if (this.owner.equals(playerId)) {
            return AuthorityType.OWNER;
        }
        AuthorityType au = this.authority.get(playerId);
        return au == null ? this.getDefaultAuthority() : au;
    }

    public AuthorityType getDefaultAuthority() {
        return this.isPublic() ? AuthorityType.NONE : AuthorityType.BAN;
    }

    @NotNull
    public Map<UUID, AuthorityType> getPlayersAuthority() {
        HashMap<UUID, AuthorityType> na = new HashMap<UUID, AuthorityType>(this.authority);
        na.put(this.owner, AuthorityType.OWNER);
        return Collections.unmodifiableMap(na);
    }

    public boolean canJoin(UUID playerId) {
        AuthorityType type = this.getAuthorityType(playerId);
        return !type.isBan() && this.publiced || type.isInvitation() && !this.publiced;
    }

    public AuthorityType getInitialAuthority() {
        return this.initialAuthority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorityInfo that = (AuthorityInfo)o;
        return this.publiced == that.publiced && Objects.equals(this.owner, that.owner) && Objects.equals(this.ownerName, that.ownerName) && Objects.equals(this.authority, that.authority) && this.initialAuthority == that.initialAuthority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.publiced, this.owner, this.ownerName, this.authority, this.initialAuthority});
    }

    public String toString() {
        return "AuthorityInfo{publiced=" + this.publiced + ", owner=" + this.owner + ", ownerName='" + this.ownerName + "', authority=" + this.authority + ", initialAuthority=" + this.initialAuthority + "}";
    }

    public static enum AuthorityType {
        OWNER("owner", 4),
        ADMIN("admin", 3),
        MEMBER("member", 2),
        READ_ONLY("read_only", 1),
        INVITATION("invitation", 0),
        BAN("ban", 0),
        NONE("none", 0);

        private final String name;
        private final Component text;
        private final int level;

        private AuthorityType(String name, int level) {
            this.name = name;
            this.text = new TranslatableComponent("imp.text.authority." + name);
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public Component getText() {
            return this.text;
        }

        public boolean isMoreOwner() {
            return this.level >= 4;
        }

        public boolean isMoreAdmin() {
            return this.level >= 3;
        }

        public boolean isMoreMember() {
            return this.level >= 2;
        }

        public boolean isMoreReadOnly() {
            return this.level >= 1;
        }

        public boolean isBan() {
            return this == BAN;
        }

        public boolean isInvitation() {
            return this == INVITATION;
        }

        public static AuthorityType getByName(String name) {
            for (AuthorityType type : AuthorityType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return NONE;
        }

        public boolean canEdit() {
            return this.isMoreAdmin();
        }

        public boolean canMusicDelete() {
            return this.isMoreAdmin();
        }

        public boolean canDelete() {
            return this == OWNER;
        }

        public boolean canAddMusic() {
            return this.isMoreMember();
        }

        public boolean canChangeAuth(AuthorityType targetAuth) {
            return this.isMoreAdmin() && this.getLevel() > targetAuth.getLevel();
        }
    }
}

