/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class MusicPlayList
implements ITAGSerializable,
IIMPComparable {
    private UUID uuid;
    private String name;
    private ImageInfo image;
    private AuthorityInfo authority;
    private List<UUID> musicList = new ArrayList<UUID>();
    private long createDate;

    public MusicPlayList() {
    }

    public MusicPlayList(UUID uuid, String name, ImageInfo image, AuthorityInfo authority, List<UUID> musicList, long createDate) {
        this.uuid = uuid;
        this.name = name;
        this.image = image;
        this.authority = authority;
        this.musicList = musicList;
        this.createDate = createDate;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128362_("UUID", this.uuid);
        tag.m_128359_("Name", this.name);
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"Image", (ITAGSerializable)this.image);
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"Authority", (ITAGSerializable)this.authority);
        OENbtUtil.writeUUIDList((CompoundTag)tag, (String)"MusicList", this.musicList);
        tag.m_128356_("CreateDate", this.createDate);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.uuid = tag.m_128342_("UUID");
        this.name = tag.m_128461_("Name");
        this.image = (ImageInfo)OENbtUtil.readSerializable((CompoundTag)tag, (String)"Image", (ITAGSerializable)new ImageInfo());
        this.authority = (AuthorityInfo)OENbtUtil.readSerializable((CompoundTag)tag, (String)"Authority", (ITAGSerializable)new AuthorityInfo());
        OENbtUtil.readUUIDList((CompoundTag)tag, (String)"MusicList", this.musicList);
        this.createDate = tag.m_128454_("CreateDate");
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public AuthorityInfo getAuthority() {
        return this.authority;
    }

    public ImageInfo getImage() {
        return this.image;
    }

    public List<UUID> getMusicList() {
        return this.musicList;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public int getPlayerCount() {
        return (int)this.authority.getPlayersAuthority().values().stream().filter(AuthorityInfo.AuthorityType::isMoreReadOnly).count();
    }

    public String toString() {
        return "MusicPlayList{uuid=" + this.uuid + ", name='" + this.name + "', image=" + this.image + ", authority=" + this.authority + ", musicList=" + this.musicList + ", createDate=" + this.createDate + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MusicPlayList that = (MusicPlayList)o;
        return this.createDate == that.createDate && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.name, that.name) && Objects.equals(this.image, that.image) && Objects.equals(this.authority, that.authority) && Objects.equals(this.musicList, that.musicList);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name, this.image, this.authority, this.musicList, this.createDate);
    }

    @Override
    public String getCompareName() {
        return this.name;
    }

    @Override
    public String getComparePlayerName() {
        return this.authority.getOwner().toString();
    }

    @Override
    public long getCompareDate() {
        return this.createDate;
    }
}

