/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMusicRinger {
    public Component getRingerName();

    public ServerLevel getRingerLevel();

    public UUID getRingerUUID();

    public boolean isRingerExist();

    public boolean isRingerPlaying();

    public void setRingerPlaying(boolean var1);

    @Nullable
    public MusicSource getRingerMusicSource();

    public boolean isRingerLoop();

    public long getRingerPosition();

    public void setRingerPosition(long var1);

    public Pair<ResourceLocation, CompoundTag> getRingerTracker();

    @NotNull
    public Vec3 getRingerSpatialPosition();

    public float getRingerVolume();

    public float getRingerRange();

    public boolean isRingerStream();

    default public boolean isRingerWait() {
        return MusicRingManager.getInstance().isWaitRinger(this.getRingerUUID(), this.getRingerLevel());
    }

    default public void ringerTick() {
        if (!MusicRingManager.getInstance().isExistRinger(this.getRingerLevel(), this.getRingerUUID())) {
            this.addRingerInRingManager();
        }
    }

    default public void addRingerInRingManager() {
        MusicRingManager.getInstance().addRinger(this.getRingerLevel(), this);
    }

    default public void ringerRestart() {
        MusicRingManager.getInstance().restartRinger(this.getRingerLevel(), this.getRingerUUID());
    }

    default public void ringerEnd() {
    }

    public boolean isRingerMute();

    default public boolean isRingerRemote() {
        return false;
    }

    @Nullable
    default public String getRingerMusicAuthor() {
        return null;
    }

    @NotNull
    default public ItemStack getRingerAntenna() {
        return ItemStack.f_41583_;
    }
}

