package dev.felnull.imp.block;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.item.IMPCreativeModeTab;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import var;

public class IMPBlocks {
    private static final Map<class_2248, class_1792> BLOCK_BY_ITEM = new HashMap<>();
    private static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create(IamMusicPlayer.MODID, class_2378.field_25105);
    private static final DeferredRegister<class_1792> BLOCK_ITEMS = DeferredRegister.create(IamMusicPlayer.MODID, class_2378.field_25108);
    public static final class_2248 MUSIC_MANAGER = register("music_manager", new MusicManagerBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9626(class_2498.field_11533).method_29292().method_9632(3.0F).method_29292()));
    public static final class_2248 CASSETTE_DECK = register("cassette_deck", new CassetteDeckBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9626(class_2498.field_11533).method_29292().method_9632(3.0F).method_29292()));
    public static final class_2248 BOOMBOX = register("boombox", new BoomboxBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9626(class_2498.field_17734).method_9632(3.0F)), n -> new BoomboxItem(n, new class_1792.class_1793().method_7892(IMPCreativeModeTab.MOD_TAB).method_7889(1)));

    private static class_2248 register(String name, class_2248 block) {
        return register(name, block, n -> new class_1747(n, new class_1792.class_1793().method_7892(IMPCreativeModeTab.MOD_TAB)));
    }

    private static class_2248 register(String name, class_2248 block, Function<class_2248, class_1792> blockItem) {
        BLOCKS.register(name, () -> block);
        var item = blockItem.apply(block);
        BLOCK_ITEMS.register(name, () -> item);
        BLOCK_BY_ITEM.put(block, item);
        return block;
    }

    public static class_1792 getItemByBlock(class_2248 block) {
        return BLOCK_BY_ITEM.getOrDefault(block, class_1802.field_8162);
    }

    public static void init() {
        BLOCKS.register();
        BLOCK_ITEMS.register();
    }
}
