package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import var;

public class WriteMusicsFixedButtonsList extends MusicsFixedButtonsList {
    private final Function<Music, Boolean> selected;

    public WriteMusicsFixedButtonsList(int x, int y, List<Music> list, PressEntry<Music> onPressEntry, Function<Music, Boolean> selected) {
        super(x, y, 129, 42, 6, new class_2588("imp.fixedList.myMusic"), list, onPressEntry);
        this.selected = selected;
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, Music item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        int k = this.method_25356(this.isHovered(bnum));
        if (selected.apply(item))
            k = 0;
        drawSmartButtonBox(poseStack, x, y, getOneButtonWidth(), getOneButtonHeight(), k);

        float sx = 1;
        var img = item.getImage();
        if (!img.isEmpty()) {
            sx += getOneButtonHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, poseStack, x + 1, y + 1, getOneButtonHeight() - 2);
        }

        poseStack.method_22903();
        float sc = 0.7f;
        OERenderUtil.poseScaleAll(poseStack, sc);
        drawSmartText(poseStack, new class_2585(OERenderUtil.getWidthString(item.getName(), getOneButtonWidth() - sx - 2 + 47, "...")), (x + sx) / sc, (y + 1f) / sc);
        poseStack.method_22909();
    }
}
