package dev.felnull.imp.client.music.player;

import dev.felnull.imp.client.music.subtitle.IMusicSubtitle;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import net.minecraft.class_243;

public interface IMusicPlayer {
    void load(long position) throws Exception;

    boolean isLoadSuccess();

    void play(long delay);

    void stop();

    void destroy();

    void pause();

    void unpause();

    boolean isPlaying();

    boolean isPaused();

    boolean isFinished();

    void setCoordinatePosition(class_243 vec3);

    class_243 getCoordinatePosition();

    void setVolume(double v);

    void setRange(float r);

    void update(MusicPlaybackInfo playbackInf);

    long getPosition();

    MusicSource getMusicSource();

    void setFixedSound(boolean enable);

    void setSubtitle(IMusicSubtitle subtitle);

    IMusicSubtitle getSubtitle();

    default float getPositionProgress() {
        return (float) getPosition() / (float) getMusicSource().getDuration();
    }
}
