package dev.felnull.imp.client.renderer.blockentity;

import dev.felnull.imp.block.MusicManagerBlock;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.client.renderer.item.AntennaItemRenderer;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.model.SpecialModelLoader;
import dev.felnull.otyacraftengine.client.renderer.blockentity.AbstractBlockEntityRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_809;
import var;

public class BoomboxBlockEntityRenderer extends AbstractBlockEntityRenderer<BoomboxBlockEntity> {
    private static final Map<BoomboxData.MonitorType, BoomboxMonitor> monitors = new HashMap<>();
    private static final class_310 mc = class_310.method_1551();

    protected BoomboxBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public void render(BoomboxBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        var state = blockEntity.method_11010();
        var data = blockEntity.getBoomboxData();
        renderBoombox(poseStack, multiBufferSource, state.getValue(MusicManagerBlock.FACING), i, j, f, data, data.getHandleRaisedProgress(f) / (float) data.getHandleRaisedMax());
    }

    public static void renderBoombox(class_4587 poseStack, class_4597 multiBufferSource, class_2350 direction, int i, int j, float f, BoomboxData data, float handleRaised) {
        float lidOpen = data.getLidOpenProgress(f) / (float) data.getLidOpenProgressMax();
        var buttons = data.getButtons();
        var cassetteTape = data.getCassetteTape();
        var antenna = data.getAntenna();
        float parabolicAntennaRoted = data.getParabolicAntennaProgress(f);
        float antennaPar = data.getAntennaProgress(f) / 30f;
        boolean changeCassetteTape = data.isChangeCassetteTape();
        var oldCassetteTape = data.getOldCassetteTape();

        var spml = SpecialModelLoader.getInstance();
        var vc = multiBufferSource.getBuffer(class_4722.method_24074());

        var handleM = spml.getModel(IMPModels.BOOMBOX_HANDLE);
        var lidM = spml.getModel(IMPModels.BOOMBOX_LID);
        var buttonsM = spml.getModel(IMPModels.BOOMBOX_BUTTONS);

        poseStack.method_22903();
        OERenderUtil.poseRotateDirection(poseStack, direction, 1);

        if (lidOpen != 0) {
            poseStack.method_22903();
            OERenderUtil.poseTrans16(poseStack, 7.7, 3.225, 6);
            OERenderUtil.poseScaleAll(poseStack, 0.72f);
            mc.method_1480().method_23178(changeCassetteTape ? oldCassetteTape : cassetteTape, class_809.class_811.field_4319, i, j, poseStack, multiBufferSource, 0);
            poseStack.method_22909();
        }

        renderAntenna(poseStack, multiBufferSource, i, j, antenna, parabolicAntennaRoted, antennaPar);

        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 1, 8, 6);
        OERenderUtil.poseTrans16(poseStack, 0.5, 0.5, 0.5);
        OERenderUtil.poseRotateX(poseStack, (1f - handleRaised) * 90f);
        OERenderUtil.poseTrans16(poseStack, -0.5, -0.5, -0.5);
        OERenderUtil.renderModel(poseStack, vc, handleM, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 5.5, 1.5, 5);
        OERenderUtil.poseTrans16(poseStack, 0.125, 0.125, 0.125);
        OERenderUtil.poseRotateX(poseStack, lidOpen * -40f);
        OERenderUtil.poseTrans16(poseStack, -0.125, -0.125, -0.125);
        OERenderUtil.renderModel(poseStack, vc, lidM, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 12.25, 9, 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 11.25, 9 - (buttons.radio() ? 0.5 : 0), 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 10.25, 9 - (buttons.start() ? 0.5 : 0), 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 9.25, 9 - (buttons.pause() ? 0.5 : 0), 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 8.25, 9, 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 7.25, 9 - (buttons.loop() ? 0.5 : 0), 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 5.55, 9, 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 4.55, 9, 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 3.55, 9 - (buttons.volMute() ? 0.5 : 0), 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtil.poseTrans16(poseStack, 2.55, 9 - (buttons.volMax() ? 0.5 : 0), 5.75);
        OERenderUtil.renderModel(poseStack, vc, buttonsM, i, j);
        poseStack.method_22909();


        poseStack.method_22903();
        poseStack.method_22904(1, 0, 0);
        OERenderUtil.poseRotateY(poseStack, 180);
        OERenderUtil.poseTrans16(poseStack, 0.6, 5.6, -4.9);
        var monitor = getMonitor(data.getMonitorType());
        float px16 = 1f / 16f;
        monitor.renderAppearance(poseStack, multiBufferSource, class_765.field_32767, j, f, px16 * 14.8f, px16 * 2.8f, data);
        poseStack.method_22909();

        poseStack.method_22909();
    }

    private static void renderAntenna(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, class_1799 antenna, float roted, float antennaPar) {
        if (!IMPItemUtil.isAntenna(antenna)) return;
        if (antenna.method_31574(IMPItems.ANTENNA)) {
            poseStack.method_22903();
            float ws = 0.025f / 2f;
            OERenderUtil.poseTrans16(poseStack, 0.25, 9, 10.25);
            poseStack.method_22904(ws, ws, ws);
            OERenderUtil.poseRotateZ(poseStack, 90);
            poseStack.method_22904(-ws, -ws, -ws);
            OERenderUtil.poseScaleAll(poseStack, 0.75f);
            AntennaItemRenderer.renderAntenna(poseStack, multiBufferSource, i, j, (-0.5f + Math.max(antennaPar, 0.5f)) * 2f, -90 + 30 * Math.min(antennaPar, 0.5f) * 2f);
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            OERenderUtil.poseTrans16(poseStack, 0.85, 8, 10.1);
            OERenderUtil.poseScaleAll(poseStack, 0.72f);
            OERenderUtil.poseRotateX(poseStack, 35);
            OERenderUtil.poseRotateZ(poseStack, 35);
            OERenderUtil.poseRotateY(poseStack, roted);
            OERenderUtil.poseTrans16(poseStack, 0, 1.3, 0);
            OERenderUtil.poseRotateX(poseStack, -30 + Math.abs(-0.5f + (roted % 120 / 120f)) * 2f * 60);
            OERenderUtil.poseTrans16(poseStack, 0, -1.3, 0);
            mc.method_1480().method_23178(antenna, class_809.class_811.field_4318, i, j, poseStack, multiBufferSource, 0);
            poseStack.method_22909();
        }
    }

    private static BoomboxMonitor getMonitor(BoomboxData.MonitorType type) {
        if (monitors.containsKey(type))
            return monitors.get(type);

        var monitor = BoomboxMonitor.createdBoomBoxMonitor(type, null);
        monitors.put(type, monitor);
        return monitor;
    }
}
