package dev.felnull.imp.entity.village;

import com.google.common.collect.ImmutableSet;
import dev.architectury.registry.level.entity.trade.SimpleTrade;
import dev.architectury.registry.level.entity.trade.TradeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.util.OERegistryUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_4158;
import var;

public class IMPVillagerProfessions {
    private static final DeferredRegister<class_3852> VILLAGER_PROFESSIONS = DeferredRegister.create(IamMusicPlayer.MODID, class_2378.field_25089);
    public static final class_3852 DJ = register("dj", IMPPoiType.DJ, class_3417.field_17743);

    private static class_3852 register(String name, class_4158 poiType, class_3414 soundEvent) {
        var pr = OERegistryUtil.createVillagerProfession(new class_2960(IamMusicPlayer.MODID, name), poiType, ImmutableSet.of(), ImmutableSet.of(), soundEvent);
        VILLAGER_PROFESSIONS.register(name, () -> pr);
        return pr;
    }

    public static void init() {
        VILLAGER_PROFESSIONS.register();
        TradeRegistry.registerVillagerTrade(DJ, 1, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPItems.CASSETTE_TAPE), 1, 1, 10, 2));
        TradeRegistry.registerVillagerTrade(DJ, 1, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPItems.CASSETTE_TAPE_GLASS), 1, 1, 10, 2));
        TradeRegistry.registerVillagerTrade(DJ, 2, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPBlocks.getItemByBlock(IMPBlocks.MUSIC_MANAGER)), 18, 1, 1, 12));
        TradeRegistry.registerVillagerTrade(DJ, 3, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPBlocks.getItemByBlock(IMPBlocks.CASSETTE_DECK)), 13, 1, 1, 12));
        TradeRegistry.registerVillagerTrade(DJ, 4, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPBlocks.getItemByBlock(IMPBlocks.BOOMBOX)), 15, 1, 3, 12));
        TradeRegistry.registerVillagerTrade(DJ, 5, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPItems.ANTENNA), 15, 1, 1, 23));
        TradeRegistry.registerVillagerTrade(DJ, 5, OERegistryUtil.createTradeItemsForEmeralds(new class_1799(IMPItems.PARABOLIC_ANTENNA), 33, 1, 1, 23));

        TradeRegistry.registerVillagerTrade(DJ, 1, OERegistryUtil.createTradeEmeraldForItems(class_1802.field_8551, 12, 15, 2));
        TradeRegistry.registerVillagerTrade(DJ, 2, OERegistryUtil.createTradeEmeraldForItems(class_1802.field_8643, 8, 10, 13));
        TradeRegistry.registerVillagerTrade(DJ, 2, OERegistryUtil.createTradeEmeraldForItems(class_1802.field_8725, 12, 15, 2));
        TradeRegistry.registerVillagerTrade(DJ, 3, OERegistryUtil.createTradeEmeraldForItems(class_1802.field_8565, 1, 5, 20));

        TradeRegistry.registerTradeForWanderingTrader(true, new SimpleTrade(new class_1799(class_1802.field_8687, 42), class_1799.field_8037, IMPItemUtil.createKamesutaAntenna(), 1, 10, 0.05f));
    }
}
