package dev.felnull.imp.inventory;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.otyacraftengine.util.OEMenuUtil;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3917;

public class IMPMenus {
    private static final DeferredRegister<class_3917<?>> MENUS = DeferredRegister.create(IamMusicPlayer.MODID, class_2378.field_25083);
    public static final class_3917<MusicManagerMenu> MUSIC_MANAGER = registerBlockMenu("music_manager", (i, inventory, blockPos, container) -> new MusicManagerMenu(i, inventory, container, blockPos));
    public static final class_3917<CassetteDeckMenu> CASSETTE_DECK = registerBlockMenu("cassette_deck", (i, inventory, blockPos, container) -> new CassetteDeckMenu(i, inventory, container, blockPos));
    public static final class_3917<BoomboxMenu> BOOMBOX = registerItemAndBlockMenu("boombox", (i, inventory, blockPos, container) -> new BoomboxMenu(i, inventory, container, blockPos, class_1799.field_8037, null), (i, inventory, itemStack, iPlayerItemLocation, container) -> new BoomboxMenu(i, inventory, container, class_2338.field_10980, itemStack, iPlayerItemLocation));

    private static <T extends class_1703> class_3917<T> registerItemAndBlockMenu(String name, OEMenuUtil.OEBlockMenuFactory<T> factoryBlock, OEMenuUtil.OEItemMenuFactory<T> factoryItem) {
        class_3917<T> menuType = OEMenuUtil.createMenuType(factoryBlock, factoryItem);
        MENUS.register(name, () -> menuType);
        return menuType;
    }

    private static <T extends class_1703> class_3917<T> registerBlockMenu(String name, OEMenuUtil.OEBlockMenuFactory<T> factory) {
        class_3917<T> menuType = OEMenuUtil.createMenuType(factory);
        MENUS.register(name, () -> menuType);
        return menuType;
    }

    public static void init() {
        MENUS.register();
    }
}
