package dev.felnull.imp.item;

import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class BoomboxItemRinger implements IBoomboxRinger {
    private final class_1309 livingEntity;
    private final UUID uuid;
    private int lastInventory;

    public BoomboxItemRinger(class_1309 livingEntity, UUID uuid) {
        this.livingEntity = livingEntity;
        this.uuid = uuid;
    }

    @Override
    public class_2561 getRingerName() {
        return new class_2588("imp.ringer.have", getBoombox().method_7954(), livingEntity.method_5476());
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218) livingEntity.field_6002;
    }

    @Override
    public UUID getRingerUUID() {
        return uuid;
    }

    @Override
    public boolean isRingerExist() {
        return livingEntity.method_5805() && !getBoombox().method_7960();
    }

    @Override
    public Pair<class_2960, class_2487> getRingerTracker() {
        if (livingEntity instanceof class_1657 player)
            return Pair.of(MusicRingManager.PLAYER_TRACKER, MusicRingManager.createPlayerTracker(player));
        return Pair.of(MusicRingManager.ENTITY_TRACKER, MusicRingManager.createEntityTracker(livingEntity));
    }

    @Override
    public @NotNull
    class_243 getRingerSpatialPosition() {
        return livingEntity.method_19538();
    }

    @NotNull
    private class_1799 getBoombox() {
        for (class_1304 value : class_1304.values()) {
            var item = livingEntity.method_6118(value);
            if (uuid.equals(BoomboxItem.getUUID(item)))
                return item;
        }
        if (livingEntity instanceof class_1657 player) {
            var li = player.method_31548().method_5438(lastInventory);
            if (uuid.equals(BoomboxItem.getUUID(li)))
                return li;

            for (int i = 0; i < player.method_31548().method_5439(); i++) {
                var item = player.method_31548().method_5438(i);
                if (uuid.equals(BoomboxItem.getUUID(item))) {
                    lastInventory = i;
                    return item;
                }
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public @NotNull BoomboxData getRingerBoomboxData() {
        return BoomboxItem.getData(getBoombox());
    }
}
