package dev.felnull.imp.item;

import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class CassetteTapeItem extends class_1792 implements class_1768 {
    private final BaseType type;

    public CassetteTapeItem(class_1793 properties, BaseType type) {
        super(properties.method_7889(1));
        this.type = type;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (getTapePercentage(itemStack) != 0) {
            if (!level.method_8608())
                setTapePercentage(itemStack, 0f);
            return class_1271.method_29237(itemStack, level.method_8608());
        }
        return super.method_7836(level, player, interactionHand);
    }

    public BaseType getType() {
        return type;
    }

    @Override
    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        var m = getMusic(itemStack);
        if (m != null)
            list.add(new class_2585(m.getName()).method_27692(class_124.field_1080));
    }

    @Nullable
    public static Music getMusic(class_1799 stack) {
        if (stack.method_7969() != null && stack.method_7969().method_10545("Music"))
            return OENbtUtil.readSerializable(stack.method_7969(), "Music", new Music());
        return null;
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        if (getMusic(stack) != null)
            return new class_2588(this.method_7866(stack) + ".written");
        return super.method_7864(stack);
    }

    public static class_1799 setMusic(class_1799 stack, Music music) {
        OENbtUtil.writeSerializable(stack.method_7948(), "Music", music);
        return stack;
    }

    public static float getTapePercentage(class_1799 stack) {
        if (stack.method_7969() != null)
            return stack.method_7969().method_10583("TapePercentage");
        return 0;
    }

    public static class_1799 setTapePercentage(class_1799 stack, float par) {
        stack.method_7948().method_10548("TapePercentage", par);
        return stack;
    }

    public static boolean isSameCassetteTape(class_1799 stack, class_1799 stack2) {
        if (class_1799.method_7973(stack, stack2)) return true;
        if (!stack.method_31574(stack2.method_7909())) return false;
        if (stack.method_7909() instanceof CassetteTapeItem && stack2.method_7909() instanceof CassetteTapeItem) {
            var m1 = getMusic(stack);
            var m2 = getMusic(stack2);
            if (m1 == null && m2 == null) return true;
            if (m1 == null || m2 == null) return false;
            return m1.equals(m2);
        }
        return false;
    }

    public static enum BaseType {
        NORMAL, GLASS
    }
}
