package dev.felnull.imp.music;

import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class MusicPlaybackInfo implements ITAGSerializable {
    public static final MusicPlaybackInfo EMPTY = new MusicPlaybackInfo(new class_2960("empty"), new class_2487(), 0, 0);
    private class_2960 tracker;
    private class_2487 trackerTag;
    private float volume;
    private float range;

    public MusicPlaybackInfo() {

    }

    public MusicPlaybackInfo(class_2960 tracker, class_2487 trackerTag, float volume, float range) {
        this.tracker = tracker;
        this.trackerTag = trackerTag;
        this.volume = volume;
        this.range = range;
    }

    public class_2487 getTrackerTag() {
        return trackerTag;
    }

    public class_2960 getTracker() {
        return tracker;
    }

    public float getVolume() {
        return volume;
    }

    public float getRange() {
        return range;
    }

    @Override
    public class_2487 save(class_2487 tag) {
        tag.method_10582("TrackerID", tracker.toString());
        tag.method_10566("TrackerTag", trackerTag);
        tag.method_10548("Volume", volume);
        tag.method_10548("Range", range);
        return tag;
    }

    @Override
    public void load(class_2487 tag) {
        this.tracker = new class_2960(tag.method_10558("TrackerID"));
        this.trackerTag = tag.method_10562("TrackerTag");
        this.volume = tag.method_10583("Volume");
        this.range = tag.method_10583("Range");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MusicPlaybackInfo that = (MusicPlaybackInfo) o;
        return Float.compare(that.volume, volume) == 0 && Float.compare(that.range, range) == 0 && Objects.equals(tracker, that.tracker) && Objects.equals(trackerTag, that.trackerTag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tracker, trackerTag, volume, range);
    }

    @Override
    public String toString() {
        return "MusicPlaybackInfo{" +
                "tracker=" + tracker +
                ", trackerTag=" + trackerTag +
                ", volume=" + volume +
                ", range=" + range +
                '}';
    }
}
