package dev.felnull.imp.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.api.IamMusicPlayerAPI;
import dev.felnull.imp.api.music.MusicRingerAccess;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.network.chat.*;
import var;
import java.util.List;

public class MusicCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        var literalCommandNode = dispatcher.register(class_2170.method_9247(IamMusicPlayer.MODID).requires(n -> n.method_9259(2))
                .then(class_2170.method_9247("ringer").executes(n -> ringerInfo(n.getSource(), null))
                        .then(class_2170.method_9247("info").executes(n -> ringerInfo(n.getSource(), null))
                                .then(class_2170.method_9244("dimension", class_2181.method_9288()).executes(n -> ringerInfo(n.getSource(), class_2181.method_9289(n, "dimension")))))
                        .then(class_2170.method_9247("list").executes(n -> ringerList(n.getSource(), null))
                                .then(class_2170.method_9244("dimension", class_2181.method_9288()).executes(n -> ringerList(n.getSource(), class_2181.method_9289(n, "dimension")))))));

        dispatcher.register(class_2170.method_9247("imp").requires(n -> n.method_9259(2)).redirect(literalCommandNode));
    }

    private static int ringerInfo(class_2168 src, class_3218 level) {
        if (level == null) {
            src.method_9226(new class_2588("commands.imp.ringer.info.all", IamMusicPlayerAPI.getRingerCount(), IamMusicPlayerAPI.getPlayingRingerCount()), false);
        } else {
            var name = level.method_27983().method_29177();
            src.method_9226(new class_2588("commands.imp.ringer.info", IamMusicPlayerAPI.getRingerCount(level), IamMusicPlayerAPI.getPlayingRingerCount(level), name), false);
        }
        return 1;
    }

    private static int ringerList(class_2168 src, class_3218 level) {
        List<MusicRingerAccess> ringers = level != null ? IamMusicPlayerAPI.getRingers(level) : IamMusicPlayerAPI.getRingers();

        if (level == null) {
            if (ringers.isEmpty()) {
                src.method_9213(new class_2588("commands.imp.ringer.list.all.notFound"));
            } else {
                src.method_9226(new class_2588("commands.imp.ringer.list.all"), false);
                for (MusicRingerAccess ringer : ringers) {
                    src.method_9226(new class_2588("commands.imp.ringer.list.all.entry" + (ringer.isPlaying() ? ".playing" : ""), ringer.getName(), createPosComponent(ringer.getSpatialPosition(), ringer.getLevel()), ringer.getLevel().method_27983().method_29177()), false);
                }
            }
        } else {
            if (ringers.isEmpty()) {
                src.method_9213(new class_2588("commands.imp.ringer.list.notFound", level.method_27983().method_29177()));
            } else {
                src.method_9226(new class_2588("commands.imp.ringer.list", level.method_27983().method_29177()), false);
                for (MusicRingerAccess ringer : ringers) {
                    src.method_9226(new class_2588("commands.imp.ringer.list.entry" + (ringer.isPlaying() ? ".playing" : ""), ringer.getName(), createPosComponent(ringer.getSpatialPosition(), ringer.getLevel())), false);
                }
            }
        }

        return 1;
    }

    private static class_2561 createPosComponent(class_243 pos, class_3218 level) {
        return class_2564.method_10885(new class_2588("chat.coordinates", pos.field_1352, pos.field_1351, pos.field_1350)).method_27694((style) -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/execute in " + level.method_27983().method_29177() + " run tp @s " + pos.field_1352 + " " + pos.field_1351 + " " + pos.field_1350)).method_10949(new class_2568(class_2568.class_5247.field_24342, new class_2588("chat.coordinates.tooltip"))));
    }
}
