package dev.felnull.imp.server.handler;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.server.commands.MusicCommand;
import dev.felnull.otyacraftengine.server.event.LootTableEvent;
import dev.felnull.otyacraftengine.server.level.LootTableAccess;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_77;
import var;

public class ServerHandler {
    private static final List<String> LOOT_NORMAL = List.of("minecraft:chests/simple_dungeon", "minecraft:chests/nether_bridge", "minecraft:chests/desert_pyramid", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/bastion_treasure", "minecraft:chests/jungle_temple", "minecraft:chests/underwater_ruin_big");
    private static final List<String> LOOT_RARE = List.of("minecraft:chests/buried_treasure", "minecraft:chests/end_city_treasure", "minecraft:chests/woodland_mansion");

    public static void init() {
        CommandRegistrationEvent.EVENT.register(ServerHandler::registerCommand);
        LootTableEvent.LOOT_TABLE_LOAD.register(ServerHandler::lootTableLoading);
    }

    private static void registerCommand(CommandDispatcher<class_2168> commandDispatcher, class_2170.class_5364 commandSelection) {
        MusicCommand.register(commandDispatcher);
    }

    private static void lootTableLoading(class_2960 name, class_60 manager, LootTableAccess access) {
        boolean normal = LOOT_NORMAL.contains(name.toString());
        boolean rare = LOOT_RARE.contains(name.toString());
        if (normal || rare) {
            var antennaPoolB = class_55.method_347().method_352(class_44.method_32448(1))
                    .method_356(class_219.method_932(rare ? 0.364364f : 0.1919810f))
                    .method_351(class_77.method_411(IMPItems.PARABOLIC_ANTENNA).method_437(1))
                    .method_351(class_77.method_411(IMPItems.ANTENNA).method_437(rare ? 1 : 4));
            access.addLootPool(new class_2960(IamMusicPlayer.MODID, "antenna"), antennaPoolB);

            var djKitPoolB = class_55.method_347().method_352(class_5662.method_32462(1, 3))
                    .method_356(class_219.method_932(0.114514f))
                    .method_351(class_77.method_411(IMPBlocks.BOOMBOX).method_437(1))
                    .method_351(class_77.method_411(IMPItems.CASSETTE_TAPE).method_437(rare ? 3 : 6));
            access.addLootPool(new class_2960(IamMusicPlayer.MODID, "dj_kit"), djKitPoolB);
        }
    }
}
