package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.music.resource.MusicSource;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public interface IMusicRinger {
    public class_2561 getRingerName();

    public class_3218 getRingerLevel();

    public UUID getRingerUUID();

    public boolean isRingerExist();

    public boolean isRingerPlaying();

    public void setRingerPlaying(boolean playing);

    public @Nullable MusicSource getRingerMusicSource();

    public boolean isRingerLoop();

    public long getRingerPosition();

    public void setRingerPosition(long position);

    public Pair<class_2960, class_2487> getRingerTracker();

    public @NotNull class_243 getRingerSpatialPosition();

    public float getRingerVolume();

    public float getRingerRange();

    public boolean isRingerStream();

    default public boolean isRingerWait() {
        return MusicRingManager.getInstance().isWaitRinger(getRingerUUID(), getRingerLevel());
    }

    default public void ringerTick() {
        if (!MusicRingManager.getInstance().isExistRinger(getRingerLevel(), getRingerUUID()))
            addRingerInRingManager();
    }

    default public void addRingerInRingManager() {
        MusicRingManager.getInstance().addRinger(getRingerLevel(), this);
    }

    default public void ringerRestart() {
        MusicRingManager.getInstance().restartRinger(getRingerLevel(), getRingerUUID());
    }

    default public void ringerEnd() {

    }

    public boolean isRingerMute();

    default public boolean isRingerRemote() {
        return false;
    }

    @Nullable
    default public String getRingerMusicAuthor() {
        return null;
    }

    @NotNull
    default public class_1799 getRingerAntenna() {
        return class_1799.field_8037;
    }
}
