package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.IamMusicPlayer;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MusicRingManager {
    private static final MusicRingManager INSTANCE = new MusicRingManager();
    public static final class_2960 FIXED_TRACKER = new class_2960(IamMusicPlayer.MODID, "fixed");
    public static final class_2960 ENTITY_TRACKER = new class_2960(IamMusicPlayer.MODID, "entity");
    public static final class_2960 PLAYER_TRACKER = new class_2960(IamMusicPlayer.MODID, "player");
    private final Map<class_3218, MusicRing> MUSIC_RINGERS = new HashMap<>();

    public static MusicRingManager getInstance() {
        return INSTANCE;
    }

    public void tick(class_3218 level) {
        var ringer = MUSIC_RINGERS.get(level);
        if (ringer == null) {
            ringer = new MusicRing(level);
            MUSIC_RINGERS.put(level, ringer);
        }
        ringer.tick(level);
    }

    public Map<class_3218, MusicRing> getMusicRingers() {
        return MUSIC_RINGERS;
    }

    public void restartRinger(class_3218 level, UUID uuid) {
        var ring = MUSIC_RINGERS.get(level);
        if (ring != null)
            ring.restart(uuid);
    }

    public void addRinger(class_3218 level, IMusicRinger ringer) {
        var ring = MUSIC_RINGERS.get(level);
        if (ring != null)
            ring.addRinger(ringer);
    }

    public boolean isWaitRinger(UUID uuid, class_3218 level) {
        var ring = MUSIC_RINGERS.get(level);
        if (ring != null)
            return ring.isWaitRinger(uuid);
        return false;
    }

    public void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, int state) {
        var ring = MUSIC_RINGERS.get(player.method_14220());
        if (ring != null)
            ring.onUpdate(player, uuid, waitUUID, state);
    }

    public void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        var ring = MUSIC_RINGERS.get(player.method_14220());
        if (ring != null)
            ring.addReadyPlayer(player, uuid, waitUUID, result, retry, elapsed);
    }

    public boolean isExistRinger(UUID uuid) {
        for (class_3218 serverLevel : MUSIC_RINGERS.keySet()) {
            if (isExistRinger(serverLevel, uuid))
                return true;
        }
        return false;
    }

    public boolean isExistRinger(class_3218 level, UUID uuid) {
        var ring = MUSIC_RINGERS.get(level);
        if (ring != null)
            return ring.getRingers().containsKey(uuid);
        return false;
    }

    public IMusicRinger getRinger(UUID uuid) {
        for (class_3218 serverLevel : MUSIC_RINGERS.keySet()) {
            var mr = MUSIC_RINGERS.get(serverLevel);
            if (mr != null) {
                var r = mr.getRingers().get(uuid);
                if (r != null)
                    return r;
            }
        }
        return null;
    }

    @Nullable
    public class_3218 getLevel(MusicRing ring) {
        for (Map.Entry<class_3218, MusicRing> entry : MUSIC_RINGERS.entrySet()) {
            if (entry.getValue() == ring)
                return entry.getKey();
        }
        return null;
    }

    public void pause() {
        MUSIC_RINGERS.forEach((n, m) -> m.pause());
    }

    public void resume() {
        MUSIC_RINGERS.forEach((n, m) -> m.resume());
    }

    public void clear() {
        MUSIC_RINGERS.forEach((n, m) -> m.depose());
        MUSIC_RINGERS.clear();
    }

    public static class_2487 createFixedTracker(class_243 vec3) {
        var tag = new class_2487();
        tag.putDouble("x", vec3.field_1352);
        tag.putDouble("y", vec3.field_1351);
        tag.putDouble("z", vec3.field_1350);
        return tag;
    }

    public static class_2487 createEntityTracker(class_1297 entity) {
        var tag = new class_2487();
        var p = entity.method_19538();
        tag.putDouble("x", p.x);
        tag.putDouble("y", p.y);
        tag.putDouble("z", p.z);
        tag.putInt("id", entity.method_5628());
        return tag;
    }

    public static class_2487 createPlayerTracker(class_1657 player) {
        var tag = new class_2487();
        var p = player.method_19538();
        tag.putDouble("x", p.x);
        tag.putDouble("y", p.y);
        tag.putDouble("z", p.z);
        tag.putUUID("id", player.method_7334().getId());
        return tag;
    }
}
