/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.MemberPlayersFixedButtonsList;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.SmartRadioButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListBaseMMMonitor;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.gui.components.RadioButton;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class DetailPlayListMMMonitor
extends PlayListBaseMMMonitor {
    private static final class_2960 DETAIL_PLAY_LIST_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/detail_play_list.png");
    private static final class_2561 MEMBER_TEXT = new class_2588("imp.text.member");
    private static final class_2561 EDIT_TEXT = new class_2588("imp.button.edit");
    private static final class_2561 AUTHORITY_TEXT = new class_2588("imp.button.authority");
    private static final class_2561 DELETE_TEXT = new class_2588("imp.button.delete").method_27692(class_124.field_1079);
    private static final class_2561 EXIT_TEXT = new class_2588("imp.button.exit").method_27692(class_124.field_1061);
    private final List<UUID> memberPlayers = new ArrayList<UUID>();
    private SmartButton editButton;
    private SmartButton deleteButton;
    private SmartButton exitButton;
    private RadioButton publishingRadio;
    private RadioButton initAuthRadio;
    private String cashName;

    public DetailPlayListMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
        this.locked();
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.editButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 87, this.getStartY() + 180, 87, 15, EDIT_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.EDIT_PLAY_LIST)));
        this.editButton.field_22764 = this.canEdit();
        this.deleteButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 5 - 87, this.getStartY() + 180, 87, 15, DELETE_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.DELETE_PLAY_LIST)));
        this.deleteButton.field_22764 = this.canDelete();
        this.exitButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 5 - 87, this.getStartY() + 180, 87, 15, EXIT_TEXT, n -> {
            class_2586 musicManagerBlock$temp = this.getScreen().getBlockEntity();
            if (musicManagerBlock$temp instanceof MusicManagerBlockEntity) {
                MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)musicManagerBlock$temp;
                NetworkManager.sendToServer((class_2960)IMPPackets.MUSIC_OR_PLAYLIST_DELETE, (class_2540)new IMPPackets.MusicOrPlayListDeleteMessage(this.getSelectedPlayList(musicManagerBlock), UUID.randomUUID(), BlockEntityExistence.getByBlockEntity((class_2586)this.getScreen().getBlockEntity()), false).toFBB());
            }
        }));
        this.exitButton.field_22764 = !this.canDelete();
        this.publishingRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 5, this.getStartY() + 140, 20, 20, this.getPublishingText(), true, true, () -> new RadioButton[0], n -> {}));
        this.publishingRadio.field_22763 = false;
        this.initAuthRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 189, this.getStartY() + 140, 20, 20, this.getInitAuthText(), true, true, () -> new RadioButton[0], n -> {}));
        this.initAuthRadio.field_22763 = false;
        this.addRenderWidget(new MemberPlayersFixedButtonsList(this.getStartX() + 189, this.getStartY() + 23, 175, 100, 5, (class_2561)new class_2588("imp.fixedList.memberPlayers"), this.memberPlayers, (FixedButtonsList.PressEntry<UUID>)((FixedButtonsList.PressEntry)(fixedButtonsList, uuid, i, i1) -> {}), this::getSelectedMusicPlayList));
        this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 174 - 3, this.getStartY() + 180, 87, 15, AUTHORITY_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.AUTHORITY)));
        this.cashName = this.getName();
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)DETAIL_PLAY_LIST_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtil.renderTextureSprite((class_2960)DETAIL_PLAY_LIST_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 5.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, this.getPublishingText(blockEntity), true);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 189.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, this.getInitAuthText(blockEntity), true);
        MusicPlayList pl = this.getSelectedMusicPlayList(blockEntity);
        ArrayList<UUID> pls = null;
        if (pl != null) {
            pls = new ArrayList<UUID>(pl.getAuthority().getPlayersAuthority().keySet());
            pls.sort(Comparator.comparingInt(o -> pl.getAuthority().getAuthorityType((UUID)o).getLevel()).reversed());
        }
        this.renderFixedListSprite(poseStack, multiBufferSource, 189.0f, 23.0f, 0.003f, 175.0f, 100.0f, i, j, onPxW, onPxH, monitorHeight, pls, 5, (poseStack1, multiBufferSource1, x, y, z, w, h, i1, j1, entry) -> {
            this.renderSmartButtonBoxSprite(poseStack1, multiBufferSource1, x, y, z + 0.001f, w, h, i1, j1, onPxW, onPxH, monitorHeight, false);
            this.renderPlayerFaceSprite(poseStack1, multiBufferSource1, (UUID)entry, x + 1.0f, y + 1.0f, z + 0.003f, h - 2.0f, i1, j1, onPxW, onPxH, monitorHeight);
            this.renderSmartTextSprite(poseStack1, multiBufferSource, (class_2561)new class_2585(OERenderUtil.getWidthString((String)OEClientUtil.getPlayerNameByUUID((UUID)entry).orElseGet(entry::toString), (float)(w - (h + 7.0f)), (String)"...")), x + h + 3.0f, y + 3.0f, z + 0.003f, onPxW, onPxH, monitorHeight, i);
            if (pl != null) {
                this.renderSmartTextSprite(poseStack1, multiBufferSource, pl.getAuthority().getAuthorityType((UUID)entry).getText(), x + h + 3.0f, y + 11.0f, z + 0.003f, onPxW, onPxH, monitorHeight, i);
            }
        });
        if (this.canEdit(blockEntity)) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, EDIT_TEXT, true);
        }
        if (this.canDelete(blockEntity)) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 5 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, DELETE_TEXT, true);
        } else {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 5 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, EXIT_TEXT, true);
        }
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 174 - 3, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, AUTHORITY_TEXT, true);
    }

    @Override
    public void tick() {
        super.tick();
        this.editButton.field_22764 = this.canEdit();
        this.deleteButton.field_22764 = this.canDelete();
        this.exitButton.field_22764 = !this.canDelete();
        this.publishingRadio.method_25355(this.getPublishingText());
        this.initAuthRadio.method_25355(this.getInitAuthText());
        this.memberPlayers.clear();
        MusicPlayList pl = this.getSelectedMusicPlayList();
        if (pl != null) {
            this.memberPlayers.addAll(pl.getAuthority().getPlayersAuthority().keySet());
            this.memberPlayers.sort(Comparator.comparingInt(o -> pl.getAuthority().getAuthorityType((UUID)o).getLevel()).reversed());
        }
        if (!this.cashName.equals(this.getName())) {
            this.cashName = this.getName();
            this.nameEditBox.method_1852(this.cashName);
        }
    }

    @Override
    protected class_2561 getPlayerListName() {
        return MEMBER_TEXT;
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        return true;
    }

    @Override
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return null;
    }

    @NotNull
    private class_2561 getInitAuthText(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            if (pl.getAuthority().getInitialAuthority() == AuthorityInfo.AuthorityType.READ_ONLY) {
                return READONLY_RDO_TEXT;
            }
            if (pl.getAuthority().getInitialAuthority() == AuthorityInfo.AuthorityType.MEMBER) {
                return MEMBER_RDO_TEXT;
            }
        }
        return class_2585.field_24366;
    }

    @NotNull
    private class_2561 getInitAuthText() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getInitAuthText(musicManagerBlockEntity);
        }
        return class_2585.field_24366;
    }

    @NotNull
    private class_2561 getPublishingText(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            if (pl.getAuthority().isPublic()) {
                return PUBLIC_RDO_TEXT;
            }
            return PRIVATE_RDO_TEXT;
        }
        return class_2585.field_24366;
    }

    @NotNull
    private class_2561 getPublishingText() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getPublishingText(musicManagerBlockEntity);
        }
        return class_2585.field_24366;
    }

    private boolean canEdit(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getAuthority().getAuthorityType(DetailPlayListMMMonitor.mc.field_1724.method_7334().getId()).canEdit();
        }
        return false;
    }

    private boolean canDelete(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getAuthority().getAuthorityType(DetailPlayListMMMonitor.mc.field_1724.method_7334().getId()).canDelete();
        }
        return false;
    }

    private boolean canEdit() {
        MusicPlayList pl = this.getSelectedMusicPlayList();
        if (pl != null) {
            return pl.getAuthority().getAuthorityType(DetailPlayListMMMonitor.mc.field_1724.method_7334().getId()).canEdit();
        }
        return false;
    }

    private boolean canDelete() {
        MusicPlayList pl = this.getSelectedMusicPlayList();
        if (pl != null) {
            return pl.getAuthority().getAuthorityType(DetailPlayListMMMonitor.mc.field_1724.method_7334().getId()).canDelete();
        }
        return false;
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.PLAY_LIST;
    }

    @Override
    @NotNull
    protected ImageInfo getImage() {
        MusicPlayList pl = this.getSelectedMusicPlayList();
        if (pl != null) {
            return pl.getImage();
        }
        return ImageInfo.EMPTY;
    }

    @Override
    @NotNull
    protected ImageInfo getImage(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getImage();
        }
        return ImageInfo.EMPTY;
    }

    @Override
    @NotNull
    protected String getName() {
        MusicPlayList pl = this.getSelectedMusicPlayList();
        if (pl != null) {
            return pl.getName();
        }
        return "";
    }

    @Override
    @NotNull
    protected String getName(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getName();
        }
        return "";
    }

    protected UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMySelectedPlayList();
    }

    protected MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return this.getSyncManager().getMyPlayList().stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    protected MusicPlayList getSelectedMusicPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedMusicPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    protected UUID getSelectedPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedPlayList(musicManagerBlockEntity);
        }
        return null;
    }
}

