/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.github.kiulian.downloader.model.playlist.PlaylistInfo;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.YoutubePlayListMusicsFixedButtonsList;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.CreatePlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.client.music.loadertypes.YoutubeMusicLoaderType;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import dev.felnull.imp.client.util.YoutubeUtil;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ImportYoutubePlayListBaseMMMonitor
extends MusicManagerMonitor {
    private static final class_2960 IMPORT_YOUTUBE_PLAY_LIST_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/import_youtube_play_list.png");
    private static final class_2561 BACK_TEXT = new class_2588("gui.back");
    private static final class_2561 LOADING_TEXT = new class_2588("imp.text.playlistLoading");
    private final List<YoutubePlayListEntry> youtubePlayListEntries = new ArrayList<YoutubePlayListEntry>();
    private SmartButton importButton;
    private PlayListLoadThread playListLoader;
    private class_342 playlistIdentifierEditBox;

    public ImportYoutubePlayListBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new SmartButton(this.getStartX() + 5, this.getStartY() + 180, 87, 15, BACK_TEXT, n -> {
            if (this.getParentType() != null) {
                this.insMonitor(this.getParentType());
            }
            this.resetImport();
        }));
        this.importButton = this.addRenderWidget(new SmartButton(this.getStartX() + 95, this.getStartY() + 180, 87, 15, CreatePlayListMMMonitor.IMPORT_TEXT, n -> this.onImport()));
        this.importButton.field_22763 = this.canImport();
        this.playlistIdentifierEditBox = this.addRenderWidget(new class_342(ImportYoutubePlayListBaseMMMonitor.mc.field_1772, this.getStartX() + 6, this.getStartY() + 164, 175, 12, (class_2561)new class_2588("imp.editBox.youtubePlaylistIdentifier")));
        this.playlistIdentifierEditBox.method_1880(300);
        this.playlistIdentifierEditBox.method_1863(this::startPlayListLoad);
        this.playlistIdentifierEditBox.method_1852(this.getImportPlayList());
        this.addRenderWidget(new YoutubePlayListMusicsFixedButtonsList(this.getStartX() + 1, this.getStartY() + 10, 368, 148, 4, (class_2561)new class_2588("imp.fixedList.youtubePlayListMusics"), this.youtubePlayListEntries));
        this.startPlayListLoad(this.getImportPlayList());
    }

    protected abstract void onImport();

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)IMPORT_YOUTUBE_PLAY_LIST_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.isPlayListLoading()) {
            this.drawSmartText(poseStack, LOADING_TEXT, this.getStartX() + 2, this.getStartY() + 11);
        }
        this.drawSmartText(poseStack, (class_2561)new class_2585(this.getImportPlayListName()), this.getStartX() + 200, this.getStartY() + 167);
        this.drawSmartText(poseStack, (class_2561)new class_2585(this.getImportPlayListAuthor()), this.getStartX() + 200, this.getStartY() + 183);
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtil.renderTextureSprite((class_2960)IMPORT_YOUTUBE_PLAY_LIST_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 5.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, BACK_TEXT, true);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 95.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, CreatePlayListMMMonitor.IMPORT_TEXT, true, !this.canImport(blockEntity));
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 6.0f, 164.0f, 0.004f, 175.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getImportPlayList(blockEntity));
        this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2585(this.getImportPlayListName(blockEntity)), 200.0f, 167.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2585(this.getImportPlayListAuthor(blockEntity)), 200.0f, 183.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        this.renderScrollbarSprite(poseStack, multiBufferSource, 360.0f, 10.0f, 0.002f, 148.0f, i, j, onPxW, onPxH, monitorHeight, 1, 1);
    }

    @Override
    public void tick() {
        super.tick();
        this.importButton.field_22763 = this.canImport();
    }

    protected int getImportPlayListMusicCount() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImportPlayListMusicCount(musicManagerBlockEntity);
        }
        return 0;
    }

    protected int getImportPlayListMusicCount(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyImportPlayListMusicCount();
    }

    protected String getImportPlayListAuthor() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImportPlayListAuthor(musicManagerBlockEntity);
        }
        return "";
    }

    protected String getImportPlayListAuthor(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyImportPlayListAuthor();
    }

    protected String getImportPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImportPlayList(musicManagerBlockEntity);
        }
        return "";
    }

    protected String getImportPlayList(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyImportIdentifier();
    }

    protected String getImportPlayListName() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImportPlayListName(musicManagerBlockEntity);
        }
        return "";
    }

    protected String getImportPlayListName(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyImportPlayListName();
    }

    protected boolean canImport() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.canImport(musicManagerBlockEntity);
        }
        return false;
    }

    protected boolean canImport(MusicManagerBlockEntity blockEntity) {
        return !this.getImportPlayList(blockEntity).isEmpty() && this.getImportPlayListMusicCount(blockEntity) > 0;
    }

    protected boolean isPlayListLoading() {
        return this.playListLoader != null && this.playListLoader.isAlive();
    }

    protected void setImportPlayListAuthor(String author) {
        this.getScreen().insImportPlayListAuthor(author);
    }

    protected void setImportPlayListMusicCount(int count) {
        this.getScreen().insImportPlayListMusicCount(count);
    }

    protected void setImportPlayListName(String name) {
        this.getScreen().insImportPlayListName(name);
    }

    protected void setImportPlayList(String id) {
        this.getScreen().insImportIdentifier(id);
    }

    @Override
    protected void onBackParent() {
        super.onBackParent();
        this.resetImport();
    }

    protected void resetImport() {
        this.setImportPlayList("");
        this.setImportPlayListAuthor("");
        this.setImportPlayListName("");
        this.setImportPlayListMusicCount(0);
    }

    protected void startPlayListLoad(String id) {
        this.stopPlayListLoad();
        this.youtubePlayListEntries.clear();
        this.resetImport();
        this.playListLoader = new PlayListLoadThread(id);
        this.playListLoader.start();
    }

    protected void stopPlayListLoad() {
        if (this.playListLoader != null) {
            this.playListLoader.interrupt();
            this.playListLoader = null;
        }
    }

    private YoutubeMusicLoaderType getYoutubeLoaderType() {
        return (YoutubeMusicLoaderType)IMPMusicLoaderTypes.getLoaderType("youtube");
    }

    private class PlayListLoadThread
    extends Thread {
        private final String id;

        public PlayListLoadThread(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            String sid = "";
            String sname = "";
            String satuhor = "";
            int sct = 0;
            try {
                Pair<AudioPlaylist, List<AudioTrack>> pl = LavaPlayerUtil.loadTracks(this.getManager(), this.id);
                if (pl.getLeft() == null) {
                    throw new IllegalStateException("Not PlayList");
                }
                for (AudioTrack track : (List)pl.getRight()) {
                    if (track.getInfo().isStream) continue;
                    MusicLoadResult ret = ImportYoutubePlayListBaseMMMonitor.this.getYoutubeLoaderType().createResult(track);
                    YoutubePlayListEntry en = new YoutubePlayListEntry(ret.name(), ret.author(), ret.source(), ret.imageInfo());
                    ImportYoutubePlayListBaseMMMonitor.this.youtubePlayListEntries.add(en);
                }
                sid = this.id;
                sct = ImportYoutubePlayListBaseMMMonitor.this.youtubePlayListEntries.size();
                sname = ((AudioPlaylist)pl.getLeft()).getName();
                String pid = YoutubeUtil.getPlayListID(this.id);
                if (pid != null) {
                    PlaylistInfo ypl = YoutubeUtil.getYoutubePlayList(pid);
                    satuhor = ypl.details().author();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayList(sid);
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayListMusicCount(sct);
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayListName(sname);
            ImportYoutubePlayListBaseMMMonitor.this.setImportPlayListAuthor(satuhor);
        }

        private AudioPlayerManager getManager() {
            return ImportYoutubePlayListBaseMMMonitor.this.getYoutubeLoaderType().getAudioPlayerManager();
        }
    }

    public record YoutubePlayListEntry(String name, String artist, MusicSource source, ImageInfo imageInfo) {
    }
}

