/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListBaseMMMonitor;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.client.music.loadertypes.YoutubeMusicLoaderType;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Pair;

public class ImportYoutubePlayListMusicsMMMonitor
extends ImportYoutubePlayListBaseMMMonitor {
    protected static final class_2561 IMPORTING_TEXT = new class_2588("imp.text.importing");
    protected static final class_2561 IMPORT_FAILURE_TEXT = new class_2588("imp.text.importFailure");
    private ImportMusicLoader importMusicLoader;
    private boolean failureImportPlayList;

    public ImportYoutubePlayListMusicsMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        class_2561 ipTx = null;
        if (this.isImporting()) {
            ipTx = IMPORTING_TEXT;
        } else if (this.failureImportPlayList) {
            ipTx = IMPORT_FAILURE_TEXT;
        } else if (this.getImportPlayListMusicCount() > 0) {
            ipTx = new class_2588("imp.text.importMusicCount", new Object[]{this.getImportPlayListMusicCount()});
        }
        if (ipTx != null) {
            this.drawSmartText(poseStack, ipTx, this.getStartX() + this.width - 95 + 7, this.getStartY() + 184);
        }
    }

    @Override
    protected void onImport() {
        if (this.isImporting()) {
            return;
        }
        String ipl = this.getImportPlayList();
        if (this.getImportPlayListMusicCount() > 0 && !ipl.isEmpty()) {
            this.startImportMusicLoader(ipl);
        }
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.IMPORT_MUSICS_SELECT;
    }

    private boolean isImporting() {
        return this.importMusicLoader != null && this.importMusicLoader.isAlive();
    }

    private void startImportMusicLoader(String id) {
        this.stopImportMusicLoader();
        this.failureImportPlayList = false;
        this.importMusicLoader = new ImportMusicLoader(id);
        this.importMusicLoader.start();
    }

    private void stopImportMusicLoader() {
        if (this.importMusicLoader != null) {
            this.importMusicLoader.interrupt();
            this.importMusicLoader = null;
        }
    }

    private class ImportMusicLoader
    extends Thread {
        private final String id;

        private ImportMusicLoader(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                ArrayList<Music> musics = new ArrayList<Music>();
                Pair<AudioPlaylist, List<AudioTrack>> pl = LavaPlayerUtil.loadTracks(this.getYoutubeLoaderType().getAudioPlayerManager(), this.id);
                if (pl.getLeft() == null) {
                    throw new IllegalStateException("Not PlayList");
                }
                for (AudioTrack track : (List)pl.getRight()) {
                    if (track.getInfo().isStream) continue;
                    MusicLoadResult ret = this.getYoutubeLoaderType().createResult(track);
                    ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry en = new ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry(ret.name(), ret.author(), ret.source(), ret.imageInfo());
                    Music music = new Music(UUID.randomUUID(), en.name(), en.artist(), en.source(), en.imageInfo(), IIMPSmartRender.mc.field_1724.method_7334().getId(), System.currentTimeMillis());
                    musics.add(music);
                }
                IIMPSmartRender.mc.method_20493(() -> {
                    class_2586 musicManagerBlock$temp = ImportYoutubePlayListMusicsMMMonitor.this.getScreen().getBlockEntity();
                    if (musicManagerBlock$temp instanceof MusicManagerBlockEntity) {
                        MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)musicManagerBlock$temp;
                        NetworkManager.sendToServer((class_2960)IMPPackets.MULTIPLE_MUSIC_ADD, (class_2540)new IMPPackets.MultipleMusicAddMessage(musicManagerBlock.getMySelectedPlayList(), musics, BlockEntityExistence.getByBlockEntity((class_2586)ImportYoutubePlayListMusicsMMMonitor.this.getScreen().getBlockEntity())).toFBB());
                    }
                    ImportYoutubePlayListMusicsMMMonitor.this.insMonitor(MusicManagerBlockEntity.MonitorType.PLAY_LIST);
                });
            }
            catch (Exception ex) {
                ImportYoutubePlayListMusicsMMMonitor.this.failureImportPlayList = true;
            }
        }

        private YoutubeMusicLoaderType getYoutubeLoaderType() {
            return (YoutubeMusicLoaderType)IMPMusicLoaderTypes.getLoaderType("youtube");
        }
    }
}

