package dev.felnull.otyacraftengine.client;

import net.minecraft.client.Minecraft;

public class ClientSyncbleTimer {
    private static final ClientSyncbleTimer INSTANCE = new ClientSyncbleTimer();
    private static final Minecraft mc = Minecraft.getInstance();
    private long lastTime = 0;

    public static ClientSyncbleTimer getInstance() {
        return INSTANCE;
    }

    public void renderTick() {

    }

    public float getFrameTime(long time) {
        if (mc.isPaused()) {
            return calFrameTime(time, lastTime);
        } else {
            return calFrameTime(time, System.currentTimeMillis());
        }
    }

    private float calFrameTime(long time, long current) {
        long delt = current - time;
        return (float) delt / 20f;
    }

}
