/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.fabric.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.fabric.client.model.OBJMtlData;
import dev.felnull.otyacraftengine.fabric.client.model.OBJMtlReader;
import dev.felnull.otyacraftengine.fabric.client.model.OBJUnbakedModelModel;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Obj;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjReader;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_804;
import net.minecraft.class_809;

public class OBJLoader {
    private static final OBJLoader INSTANCE = new OBJLoader();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_809.class, (Object)new class_809.class_810()).registerTypeAdapter(class_804.class, (Object)new class_804.class_805()).create();

    public static OBJLoader getInstance() {
        return INSTANCE;
    }

    public class_1100 loadModel(class_2960 location) {
        class_2960 modelPath = new class_2960(location.method_12836(), location.method_12832() + ".json");
        Optional<JsonElement> loader = this.getRawModelDatas(modelPath, "loader");
        if (loader.isPresent() && "forge:obj".equals(loader.get().getAsString())) {
            Optional<JsonElement> model = this.getRawModelDatas(modelPath, "model");
            Optional<JsonElement> display = this.getRawModelDatas(modelPath, "display");
            class_809 transforms = display.isPresent() ? (class_809)GSON.fromJson(display.get(), class_809.class) : (class_809)GSON.fromJson((JsonElement)new JsonObject(), class_809.class);
            if (model.isPresent()) {
                return this.loadModel(new class_2960(model.get().getAsString()), transforms);
            }
        }
        return null;
    }

    public class_1100 loadModel(class_2960 location, class_809 transforms) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        if (resourceManager.method_18234(location)) {
            try {
                InputStreamReader reader = new InputStreamReader(resourceManager.method_14486(location).method_14482());
                Obj obj = ObjUtils.convertToRenderable(ObjReader.read(reader));
                return new OBJUnbakedModelModel(obj, this.loadMTL(location, obj.getMtlFileNames()), transforms);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Map<String, OBJMtlData> loadMTL(class_2960 modelLocation, List<String> mtlNames) throws Exception {
        LinkedHashMap<String, OBJMtlData> mtls = new LinkedHashMap<String, OBJMtlData>();
        class_3300 manager = class_310.method_1551().method_1478();
        for (String name : mtlNames) {
            class_2960 resourceId = new class_2960(modelLocation.method_12836(), Paths.get(modelLocation.method_12832(), new String[0]).getParent().resolve(name).toString().replace("\\", "/"));
            if (!manager.method_18234(resourceId)) continue;
            class_3298 resource = manager.method_14486(resourceId);
            OBJMtlReader.read(resource.method_14482()).forEach(mtl -> mtls.put(mtl.getName(), (OBJMtlData)mtl));
        }
        return mtls;
    }

    private Optional<JsonElement> getRawModelDatas(class_2960 modelPath, String name) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        try {
            while (modelPath != null) {
                if (!resourceManager.method_18234(modelPath)) {
                    return Optional.empty();
                }
                InputStreamReader reader = new InputStreamReader(resourceManager.method_14486(modelPath).method_14482());
                JsonObject rawModel = class_3518.method_15255((Reader)reader);
                if (rawModel.has(name)) {
                    return Optional.ofNullable(rawModel.get(name));
                }
                if (rawModel.has("parent")) {
                    class_2960 modelId = new class_2960(rawModel.get("parent").getAsString());
                    modelPath = new class_2960(modelId.method_12836(), "models/" + modelId.method_12832() + ".json");
                    continue;
                }
                modelPath = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Optional.empty();
    }
}

