/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjln;

import dev.felnull.fnjln.FelNullJavaLibraryNative;
import dev.felnull.fnjln.jni.windows.WindowsOpenFileName;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.os.OSs;
import java.io.File;
import java.nio.file.Path;

public class FNNativeFileChooser {
    private String title;
    private String defExt;
    private Flag flag;
    private Path initialDirectory;
    private String initialName;
    private Filter[] filters;
    private int initialFilterIndex;

    public FNNativeFileChooser() {
    }

    public FNNativeFileChooser(String title) {
        this.title = title;
    }

    public FNNativeFileChooser(String title, Flag flags, Filter ... filters) {
        this.title = title;
        this.flag = flags;
        this.filters = filters;
    }

    public static boolean isSupport() {
        try {
            FelNullJavaLibraryNative.check();
        }
        catch (RuntimeException ex) {
            return false;
        }
        return OSs.isWindows() && OSs.isX64();
    }

    public void setInitialDirectory(Path initialDirectory) {
        this.initialDirectory = initialDirectory;
    }

    public void setFilters(Filter[] filters) {
        this.filters = filters;
    }

    public void setDefExt(String defExt) {
        this.defExt = defExt;
    }

    public File[] openWindow() {
        return this.openWindow(0L);
    }

    public File[] openWindow(long hwndId) {
        FelNullJavaLibraryNative.check();
        if (OSs.isWindows() && OSs.isX64()) {
            return WindowsOpenFileName.open(this, hwndId);
        }
        return null;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public int getInitialFilterIndex() {
        return this.initialFilterIndex;
    }

    public Path getInitialDirectory() {
        return this.initialDirectory;
    }

    public String getDefExt() {
        return this.defExt;
    }

    public String getTitle() {
        return this.title;
    }

    public String getInitialName() {
        return this.initialName;
    }

    public static class Filter {
        private final String description;
        private final String[] extension;

        public Filter(String description, String ... extension) {
            this.description = description;
            this.extension = extension;
        }

        public String toWindowsFilterText() {
            String winExsStr;
            String exsStr;
            if (this.extension == null || this.extension.length == 0) {
                exsStr = "*";
                winExsStr = "*.*";
            } else {
                CharSequence[] winExs = new String[this.extension.length];
                for (int i = 0; i < winExs.length; ++i) {
                    winExs[i] = "*." + this.extension[i];
                }
                exsStr = String.join((CharSequence)"", winExs);
                winExsStr = String.join((CharSequence)";", winExs);
            }
            return this.description + " (" + exsStr + ")\u0000" + winExsStr + "\u0000";
        }
    }

    public static class Flag {
        private boolean multiSelect;
        private boolean explorer;
        private boolean creatEPrompt;
        private boolean fileMustExist;
        private boolean hideReadOnly;
        private boolean nodeReferenceLinks;
        private boolean readOnly;

        public Flag allowMultiSelect(boolean allow) {
            this.multiSelect = allow;
            return this;
        }

        public Flag explorer(boolean explorer) {
            this.explorer = explorer;
            return this;
        }

        public Flag creatEPrompt(boolean creatEPrompt) {
            this.creatEPrompt = creatEPrompt;
            return this;
        }

        public Flag fileMustExist(boolean fileMustExist) {
            this.fileMustExist = fileMustExist;
            return this;
        }

        public Flag hideReadOnly(boolean hideReadOnly) {
            this.hideReadOnly = hideReadOnly;
            return this;
        }

        public Flag nodeReferenceLinks(boolean nodeReferenceLinks) {
            this.nodeReferenceLinks = nodeReferenceLinks;
            return this;
        }

        public Flag readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public boolean isCreatEPrompt() {
            return this.creatEPrompt;
        }

        public boolean isExplorer() {
            return this.explorer;
        }

        public boolean isFileMustExist() {
            return this.fileMustExist;
        }

        public boolean isHideReadOnly() {
            return this.hideReadOnly;
        }

        public boolean isMultiSelect() {
            return this.multiSelect;
        }

        public boolean isNodeReferenceLinks() {
            return this.nodeReferenceLinks;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }
}

