/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjln.jni.windows;

import dev.felnull.fnjln.FNNativeFileChooser;
import dev.felnull.fnjln.jni.windows.WindowsLibrary;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class WindowsOpenFileName {
    public static File[] open(FNNativeFileChooser fc, long hwnd) {
        String title = fc.getTitle() == null ? "" : fc.getTitle();
        String initDir = fc.getInitialDirectory() == null ? "" : fc.getInitialDirectory().toAbsolutePath().toString();
        String initName = fc.getInitialName() == null ? "" : fc.getInitialName();
        String defExt = fc.getDefExt() == null ? "" : fc.getDefExt();
        int flgNum = WindowsOpenFileName.createFlagNum(fc.getFlag());
        byte[] op = WindowsLibrary.getOpenFileName(hwnd, title, initDir, initName, defExt, WindowsOpenFileName.createFilterString(fc.getFilters()), fc.getInitialFilterIndex(), flgNum);
        if (op == null) {
            return null;
        }
        String str = new String(op);
        if (!str.endsWith("\u0000\u0000")) {
            return null;
        }
        String[] files = (str = str.substring(0, str.length() - 2)).split(WindowsOpenFileName.getFlgStr(flgNum));
        if (files.length == 0) {
            return new File[0];
        }
        if (files.length == 1) {
            return new File[]{new File(files[0])};
        }
        Path dir = Paths.get(files[0], new String[0]);
        File[] Ffiles = new File[files.length - 1];
        for (int i = 0; i < Ffiles.length; ++i) {
            Ffiles[i] = dir.resolve(files[1 + i]).toFile();
        }
        return Ffiles;
    }

    private static String getFlgStr(int flg) {
        boolean ex;
        boolean am = (flg & Flag.OFN_ALLOWMULTISELECT.getNum()) != 0;
        boolean bl = ex = (flg & Flag.OFN_EXPLORER.getNum()) != 0;
        if (am && !ex) {
            return " ";
        }
        return "\u0000";
    }

    private static String createFilterString(FNNativeFileChooser.Filter[] filters) {
        if (filters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (FNNativeFileChooser.Filter filter : filters) {
            sb.append(filter.toWindowsFilterText());
        }
        return sb.toString();
    }

    private static int createFlagNum(FNNativeFileChooser.Flag flags) {
        if (flags == null) {
            return 0;
        }
        int num = 0;
        if (flags.isCreatEPrompt()) {
            num |= Flag.OFN_CREATEPROMPT.getNum();
        }
        if (flags.isExplorer()) {
            num |= Flag.OFN_EXPLORER.getNum();
        }
        if (flags.isFileMustExist()) {
            num |= Flag.OFN_FILEMUSTEXIST.getNum();
        }
        if (flags.isHideReadOnly()) {
            num |= Flag.OFN_HIDEREADONLY.getNum();
        }
        if (flags.isMultiSelect()) {
            num |= Flag.OFN_ALLOWMULTISELECT.getNum();
        }
        if (flags.isNodeReferenceLinks()) {
            num |= Flag.OFN_NOREADONLYRETURN.getNum();
        }
        if (flags.isReadOnly()) {
            num |= Flag.OFN_READONLY.getNum();
        }
        return num;
    }

    public static enum Flag {
        OFN_READONLY(1),
        OFN_OVERWRITEPROMPT(2),
        OFN_HIDEREADONLY(4),
        OFN_NOCHANGEDIR(8),
        OFN_SHOWHELP(16),
        OFN_ENABLEHOOK(32),
        OFN_ENABLETEMPLATE(64),
        OFN_ENABLETEMPLATEHANDLE(128),
        OFN_NOVALIDATE(256),
        OFN_ALLOWMULTISELECT(512),
        OFN_EXTENSIONDIFFERENT(1024),
        OFN_PATHMUSTEXIST(2048),
        OFN_FILEMUSTEXIST(4096),
        OFN_CREATEPROMPT(8192),
        OFN_SHAREAWARE(16384),
        OFN_NOREADONLYRETURN(32768),
        OFN_NOTESTFILECREATE(65536),
        OFN_NONETWORKBUTTON(131072),
        OFN_NOLONGNAMES(262144),
        OFN_EXPLORER(524288),
        OFN_NODEREFERENCELINKS(0x100000),
        OFN_LONGNAMES(0x200000),
        OFN_ENABLEINCLUDENOTIFY(0x400000),
        OFN_ENABLESIZING(0x800000),
        OFN_DONTADDTORECENT(0x2000000),
        OFN_FORCESHOWHIDDEN(0x10000000),
        OFN_EX_NOPLACESBAR(1),
        OFN_SHAREFALLTHROUGH(2),
        OFN_SHARENOWARN(1),
        OFN_SHAREWARN(0);

        private int num;

        private Flag(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }
    }
}

