/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.loader.PlayerInfoManager;
import dev.felnull.otyacraftengine.client.loader.URLTextureManager;
import dev.felnull.otyacraftengine.client.util.ClientUtilInit;
import dev.felnull.otyacraftengine.util.OEItemUtil;
import dev.felnull.otyacraftengine.util.OETagUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_746;

public class ClientHandler {
    public static void init() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(ClientHandler::onQuit);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ClientHandler::onJoin);
        ClientTooltipEvent.ITEM.register(ClientHandler::onTooltip);
    }

    private static void onJoin(class_746 localPlayer) {
        ClientHandler.onReset();
    }

    private static void onQuit(class_746 localPlayer) {
        ClientHandler.onReset();
    }

    private static void onReset() {
        ClientUtilInit.clear();
        PlayerInfoManager.getInstance().reload();
        URLTextureManager.getInstance().reload();
    }

    private static void onTooltip(class_1799 itemStack, List<class_2561> list, class_1836 tooltipFlag) {
        if (itemStack.method_7960()) {
            return;
        }
        class_1792 item = itemStack.method_7909();
        if (OtyacraftEngine.CONFIG.showTagTooltip) {
            Set<class_2960> itemTags = OETagUtil.getTags(item);
            class_1792 class_17922 = item;
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                Set<class_2960> blockTags = OETagUtil.getTags(blockItem.method_7711());
                HashSet<class_2960> bothTags = new HashSet<class_2960>();
                boolean firstItem = false;
                boolean firstBlock = false;
                for (class_2960 tag : itemTags) {
                    if (!blockTags.contains(tag)) {
                        if (!firstItem) {
                            list.add((class_2561)new class_2585("Item tags").method_27692(class_124.field_1075));
                            firstItem = true;
                        }
                        list.add((class_2561)new class_2585(" - " + tag));
                        continue;
                    }
                    bothTags.add(tag);
                }
                Iterator<Object> iterator = blockTags.iterator();
                while (iterator.hasNext()) {
                    class_2960 blockTag = (class_2960)iterator.next();
                    if (!itemTags.contains(blockTag)) {
                        if (!firstBlock) {
                            list.add((class_2561)new class_2585("Block tags").method_27692(class_124.field_1075));
                            firstBlock = true;
                        }
                        list.add((class_2561)new class_2585(" - " + blockTag));
                        continue;
                    }
                    bothTags.add(blockTag);
                }
                if (!bothTags.isEmpty()) {
                    list.add((class_2561)new class_2585("Both tags").method_27692(class_124.field_1075));
                    for (class_2960 tag : bothTags) {
                        list.add((class_2561)new class_2585(" - " + tag));
                    }
                }
            } else if (!itemTags.isEmpty()) {
                list.add((class_2561)new class_2585("Item tags").method_27692(class_124.field_1075));
                for (class_2960 tag : itemTags) {
                    list.add((class_2561)new class_2585(" - " + tag));
                }
            }
            Set<class_1299<?>> entityTypes = ClientHandler.getEntityTypesByItem(itemStack);
            HashSet entityTypeTags = new HashSet();
            entityTypes.forEach(n -> entityTypeTags.addAll(OETagUtil.getTags(n)));
            if (!entityTypeTags.isEmpty()) {
                list.add((class_2561)new class_2585("Entity tags").method_27692(class_124.field_1075));
                for (class_2960 tag : entityTypeTags) {
                    list.add((class_2561)new class_2585(" - " + tag));
                }
            }
        }
        if (OtyacraftEngine.CONFIG.showModNameTooltip) {
            class_2960 modid = class_2378.field_11142.method_10221((Object)item);
            list.add((class_2561)new class_2585(Platform.getMod((String)modid.method_12836()).getName()).method_27692(class_124.field_1077));
        }
    }

    private static Set<class_1299<?>> getEntityTypesByItem(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_1792 class_17922 = item;
        if (class_17922 instanceof class_1826) {
            class_1826 spawnEggItem = (class_1826)class_17922;
            return Set.of(spawnEggItem.method_8015(stack.method_7969()));
        }
        class_17922 = item;
        if (class_17922 instanceof class_1785) {
            class_1785 mobBucketItem = (class_1785)class_17922;
            return Set.of(OEItemUtil.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }
}

