/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.felnull.otyacraftengine.client.renderer.texture.DynamicGifTexture;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import dev.felnull.otyacraftengine.libs.com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNImageUtil;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNMath;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1068;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OETextureUtil {
    private static final class_310 mc = class_310.method_1551();
    protected static final Map<UUID, TextureLoadResult> NATIVE_TEXTURES = new HashMap<UUID, TextureLoadResult>();
    protected static final List<UUID> LOAD_TEXTURES = new ArrayList<UUID>();
    protected static class_2960 LOADING_ICON;
    protected static final Map<String, String> URL_FILENAME_INDEX;
    protected static final Map<String, UUID> URL_TEXTURES_UUIDS;
    protected static final List<String> URL_LOAD_TEXTURES;

    public static class_2960 getLoadingIcon() {
        if (LOADING_ICON == null) {
            class_3300 rm = mc.method_1478();
            try {
                LOADING_ICON = OETextureUtil.loadNativeTexture(rm.method_14486(new class_2960("otyacraftengine", "textures/gui/loading.gif")).method_14482(), class_1047.method_4539()).location();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return LOADING_ICON;
    }

    public static class_2960 getPlayerSkinTexture(UUID uuid) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, uuid);
    }

    public static class_2960 getPlayerCapeTexture(UUID uuid) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, uuid);
    }

    public static class_2960 getPlayerElytraTexture(UUID uuid) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, uuid);
    }

    public static class_2960 getPlayerSkinTexture(String name) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, name);
    }

    public static class_2960 getPlayerCapeTexture(String name) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, name);
    }

    public static class_2960 getPlayerElytraTexture(String name) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, name);
    }

    @Nullable
    public static class_2960 getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull String name) {
        class_640 pl;
        if (OETextureUtil.mc.field_1724 != null && (pl = OETextureUtil.mc.field_1724.field_3944.method_2874(name)) != null) {
            return switch (type) {
                case MinecraftProfileTexture.Type.SKIN -> pl.method_2968();
                case MinecraftProfileTexture.Type.CAPE -> pl.method_2979();
                case MinecraftProfileTexture.Type.ELYTRA -> pl.method_2957();
                default -> throw new IncompatibleClassChangeError();
            };
        }
        GameProfile gameProfile = OEClientUtil.getClientPlayerProfile(name);
        MinecraftProfileTexture tex = (MinecraftProfileTexture)mc.method_1582().method_4654(gameProfile).get(type);
        return tex != null ? mc.method_1582().method_4656(tex, type) : (type == MinecraftProfileTexture.Type.SKIN ? class_1068.method_4648((UUID)class_1657.method_7271((GameProfile)gameProfile)) : null);
    }

    public static class_2960 getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        class_640 pl;
        if (OETextureUtil.mc.field_1724 != null && (pl = OETextureUtil.mc.field_1724.field_3944.method_2871(uuid)) != null) {
            return switch (type) {
                case MinecraftProfileTexture.Type.SKIN -> pl.method_2968();
                case MinecraftProfileTexture.Type.CAPE -> pl.method_2979();
                case MinecraftProfileTexture.Type.ELYTRA -> pl.method_2957();
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return OEClientUtil.getPlayerNameByUUID(uuid).map(n -> OETextureUtil.getPlayerTexture(type, n)).orElseGet(() -> type == MinecraftProfileTexture.Type.SKIN ? class_1068.method_4648((UUID)uuid) : null);
    }

    public static class_2960 getURLTextureAsyncLoad(String url, boolean cash) {
        return OETextureUtil.getURLTextureAsyncLoad(url, cash, class_1047.method_4539());
    }

    public static class_2960 getURLTextureAsyncLoad(String url, boolean cash, class_2960 failureTexture) {
        return OETextureUtil.getURLTextureAsyncLoad(url, cash, OETextureUtil.getLoadingIcon(), failureTexture);
    }

    public static class_2960 getURLTextureAsyncLoad(String url, boolean cash, class_2960 loadTexture, class_2960 failureTexture) {
        if (URL_TEXTURES_UUIDS.containsKey(url)) {
            return OETextureUtil.getNativeTexture(URL_TEXTURES_UUIDS.get(url), null);
        }
        if (URL_LOAD_TEXTURES.contains(url)) {
            return loadTexture;
        }
        CompletableFuture.runAsync(() -> {
            URL_LOAD_TEXTURES.add(url);
            TextureLoadResult tex = OETextureUtil.loadURLTexture(url, cash, failureTexture);
            mc.method_20493(() -> {
                UUID id = UUID.randomUUID();
                NATIVE_TEXTURES.put(id, tex);
                URL_LOAD_TEXTURES.remove(url);
                URL_TEXTURES_UUIDS.put(url, id);
            });
        });
        return loadTexture;
    }

    public static class_2960 getURLTexture(String url, boolean cash) {
        return OETextureUtil.getURLTexture(url, cash, class_1047.method_4539());
    }

    public static class_2960 getURLTexture(String url, boolean cash, class_2960 failureTexture) {
        if (URL_TEXTURES_UUIDS.containsKey(url)) {
            return OETextureUtil.getNativeTexture(URL_TEXTURES_UUIDS.get(url), null);
        }
        UUID id = UUID.randomUUID();
        TextureLoadResult tx = OETextureUtil.loadURLTexture(url, cash, failureTexture);
        URL_TEXTURES_UUIDS.put(url, id);
        NATIVE_TEXTURES.put(id, tx);
        return tx.location();
    }

    private static TextureLoadResult loadURLTexture(String url, boolean cash, class_2960 failureTexture) {
        try {
            InputStream stream;
            byte[] md5 = FNDataUtil.createMD5Hash(url.getBytes(StandardCharsets.UTF_8));
            String identification = Base64.getEncoder().encodeToString(md5);
            Path oep = OEPaths.getClientOEFolderPath().resolve("url_textures");
            if (URL_FILENAME_INDEX.containsKey(identification) && oep.resolve(URL_FILENAME_INDEX.get(identification)).toFile().exists()) {
                stream = new BufferedInputStream(new FileInputStream(oep.resolve(URL_FILENAME_INDEX.get(identification)).toFile()));
            } else {
                long max;
                HttpURLConnection connection = FNURLUtil.getConnection(new URL(url));
                long length = connection.getContentLengthLong();
                if (length > (max = 0x300000L)) {
                    throw new IOException("Size Over: " + max + "byte current: " + length + "byte");
                }
                if (cash) {
                    byte[] data = connection.getInputStream().readAllBytes();
                    UUID uid = UUID.randomUUID();
                    Files.write(oep.resolve(uid.toString()), data, new OpenOption[0]);
                    URL_FILENAME_INDEX.put(identification, uid.toString());
                    stream = new ByteArrayInputStream(data);
                } else {
                    stream = connection.getInputStream();
                }
            }
            return OETextureUtil.loadNativeTexture(stream, failureTexture);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new TextureLoadResult(failureTexture, true);
        }
    }

    public static class_2960 getNativeTextureAsyncLoad(UUID id, InputStream stream) {
        return OETextureUtil.getNativeTextureAsyncLoad(id, stream, class_1047.method_4539());
    }

    public static class_2960 getNativeTextureAsyncLoad(UUID id, InputStream stream, class_2960 failureTexture) {
        return OETextureUtil.getNativeTextureAsyncLoad(id, stream, OETextureUtil.getLoadingIcon(), failureTexture);
    }

    public static class_2960 getNativeTextureAsyncLoad(UUID id, InputStream stream, class_2960 loadTexture, class_2960 failureTexture) {
        if (NATIVE_TEXTURES.containsKey(id)) {
            return NATIVE_TEXTURES.get(id).location();
        }
        if (LOAD_TEXTURES.contains(id)) {
            return loadTexture;
        }
        CompletableFuture.runAsync(() -> {
            LOAD_TEXTURES.add(id);
            TextureLoadResult tex = OETextureUtil.loadNativeTexture(stream, failureTexture);
            mc.method_20493(() -> {
                NATIVE_TEXTURES.put(id, tex);
                LOAD_TEXTURES.remove(id);
            });
        });
        return loadTexture;
    }

    public static TextureScale getTextureScale(class_2960 location) {
        class_1044 class_10442;
        if (location != null && (class_10442 = mc.method_1531().method_4619(location)) instanceof class_1043) {
            class_1043 texture = (class_1043)class_10442;
            int w = texture.method_4525().method_4307();
            int h = texture.method_4525().method_4323();
            FNVec2d sc = FNMath.scale(w, h);
            return new TextureScale(sc.getX(), sc.getY());
        }
        return null;
    }

    public static class_2960 getNativeTexture(UUID id, InputStream stream) {
        return OETextureUtil.getNativeTexture(id, stream, class_1047.method_4539());
    }

    public static class_2960 getNativeTexture(UUID id, InputStream stream, class_2960 failureTexture) {
        if (NATIVE_TEXTURES.containsKey(id)) {
            return NATIVE_TEXTURES.get(id).location();
        }
        TextureLoadResult tex = OETextureUtil.loadNativeTexture(stream, failureTexture);
        NATIVE_TEXTURES.put(id, tex);
        return tex.location();
    }

    protected static TextureLoadResult loadNativeTexture(InputStream stream, class_2960 failureTexture) {
        try {
            byte[] data = stream.readAllBytes();
            GifDecoder decoder = new GifDecoder();
            boolean gifFlg = decoder.read(new ByteArrayInputStream(data)) == 0;
            AtomicReference tex = new AtomicReference();
            if (!gifFlg) {
                class_1011 ni = class_1011.method_4309((InputStream)new ByteArrayInputStream(data));
                mc.method_20493(() -> tex.set(mc.method_1531().method_4617("native_texture", new class_1043(ni)))).get();
            } else {
                DynamicGifTexture.ImageFrame[] frames = new DynamicGifTexture.ImageFrame[decoder.getFrameCount()];
                long duration = 0L;
                for (int i = 0; i < decoder.getFrameCount(); ++i) {
                    frames[i] = new DynamicGifTexture.ImageFrame(class_1011.method_4309((InputStream)FNImageUtil.toInputStream(decoder.getFrame(i), "png")), decoder.getDelay(i));
                    duration += (long)decoder.getDelay(i);
                }
                long finalDuration = duration;
                mc.method_20493(() -> tex.set(mc.method_1531().method_4617("native_texture", (class_1043)new DynamicGifTexture(finalDuration, frames)))).get();
            }
            stream.close();
            return new TextureLoadResult((class_2960)tex.get(), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new TextureLoadResult(failureTexture, true);
        }
    }

    public static void freeNativeTexture(UUID id) {
        if (NATIVE_TEXTURES.containsKey(id)) {
            if (!NATIVE_TEXTURES.get(id).failure()) {
                OETextureUtil.freeTexture(NATIVE_TEXTURES.get(id).location());
            }
            NATIVE_TEXTURES.remove(id);
        }
    }

    public static void freeTexture(class_2960 location) {
        OEClientExpectPlatform.freeTexture(location);
    }

    static {
        URL_FILENAME_INDEX = new HashMap<String, String>();
        URL_TEXTURES_UUIDS = new HashMap<String, UUID>();
        URL_LOAD_TEXTURES = new ArrayList<String>();
    }

    private record TextureLoadResult(class_2960 location, boolean failure) {
    }

    public record TextureScale(double w, double h) {
    }
}

