package dev.felnull.otyacraftengine.fabric.mixin.client;

import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_759;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import var;

@Mixin(class_759.class)
public abstract class ItemInHandRendererMixin {
    @Shadow
    protected abstract void renderArmWithItem(class_742 abstractClientPlayer, float f, float g, class_1268 interactionHand, float h, class_1799 itemStack, float i, class_4587 poseStack, class_4597 multiBufferSource, int j);

    @Shadow
    @Final
    private class_310 minecraft;

    @Shadow
    private class_1799 mainHandItem;

    @Shadow
    private class_1799 offHandItem;

    @Redirect(method = "renderHandsWithItems", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"))
    private void injected(class_759 instance, class_742 abstractClientPlayer, float f, float g, class_1268 interactionHand, float h, class_1799 itemStack, float i, class_4587 poseStack, class_4597 multiBufferSource, int j) {
        if (OEClientEventHooks.onRenderHand(poseStack, multiBufferSource, interactionHand, j, f, g, h, i, itemStack))
            renderArmWithItem(abstractClientPlayer, f, g, interactionHand, h, itemStack, i, poseStack, multiBufferSource, j);
    }


    @Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;isHandsBusy()Z"))
    private void tick(CallbackInfo ci) {
        var mitem = minecraft.field_1724.method_6047();
        if (!OEClientEventHooks.onChangeHandHeight(class_1268.field_5808, this.mainHandItem, mitem)) {
            this.mainHandItem = mitem;
        }

        var oitem = minecraft.field_1724.method_6079();
        if (!OEClientEventHooks.onChangeHandHeight(class_1268.field_5810, this.offHandItem, oitem)) {
            this.offHandItem = oitem;
        }
    }
}
