package dev.felnull.otyacraftengine.fabric.tag;

import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import net.minecraft.tags.*;
import var;
import java.util.*;
import java.util.function.Supplier;

public class TagCache<T> {
    public static final TagCache<class_1792> ITEM = new TagCache<>(class_3489::method_15106);
    public static final TagCache<class_2248> BLOCK = new TagCache<>(class_3481::method_15073);
    public static final TagCache<class_1299<?>> ENTITY_TYPE = new TagCache<>(class_3483::method_15082);

    private final Supplier<class_5414<T>> tagSupplier;
    private final Map<T, Cache> chashs = new HashMap<>();

    public TagCache(Supplier<class_5414<T>> tagSupplier) {
        this.tagSupplier = tagSupplier;
    }

    public Set<class_2960> getTags(T target) {
        if (!chashs.containsKey(target))
            chashs.put(target, new Cache());

        var tags = tagSupplier.get();
        var ch = chashs.get(target);
        if (ch.cache == null || ch.allCache != tags.getAllTags()) {
            ch.cache = Collections.unmodifiableSet(new HashSet<>(tags.getMatchingTags(target)));
            ch.allCache = tags.getAllTags();
        }
        return ch.cache;
    }

    private class Cache {
        private Map<class_2960, class_3494<T>> allCache;
        private Set<class_2960> cache;
    }
}
