package dev.felnull.otyacraftengine.fabric.client.handler;

import dev.felnull.otyacraftengine.client.event.FabricOBJLoaderEvent;
import dev.felnull.otyacraftengine.fabric.client.model.OBJLoader;
import net.fabricmc.fabric.api.client.model.*;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import var;

public class ModelResourceHandler implements ModelResourceProvider, ModelVariantProvider {
    public static void init() {
        var h = new ModelResourceHandler();
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(n -> h);
        ModelLoadingRegistry.INSTANCE.registerVariantProvider(n -> h);
    }

    @Override
    public @Nullable class_1100 loadModelResource(class_2960 resourceId, ModelProviderContext context) {
        try {
            if (FabricOBJLoaderEvent.LOAD.invoker().load(resourceId).isTrue())
                return OBJLoader.getInstance().loadModel(new class_2960(resourceId.method_12836(), "models/" + resourceId.method_12832()));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public @Nullable class_1100 loadModelVariant(class_1091 modelId, ModelProviderContext context) throws ModelProviderException {
        try {
            if (FabricOBJLoaderEvent.LOAD.invoker().load(modelId).isTrue())
                return OBJLoader.getInstance().loadModel(new class_2960(modelId.method_12836(), "models/" + modelId.method_12832()));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}
