package dev.felnull.otyacraftengine.client.gui.components;

import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import var;

public class RadioButton extends class_4264 implements IOEBaseComponent {
    private final boolean showLabel;
    private final Supplier<RadioButton[]> group;
    private final class_2960 texture;
    private final int textureX;
    private final int textureY;
    private final int textureWidth;
    private final int textureHeight;
    private final int textureSizeWidth;
    private final int textureSizeHeight;
    private final Consumer<RadioButton> onPress;
    private boolean selected;

    public RadioButton(int x, int y, int w, int h, class_2561 title, boolean selected, boolean showLabel, Supplier<RadioButton[]> group, Consumer<RadioButton> onPress) {
        this(x, y, w, h, title, selected, showLabel, group, WIDGETS, 0, 0, 20, 20, 256, 256, onPress);
    }

    public RadioButton(int x, int y, int w, int h, class_2561 title, boolean selected, boolean showLabel, Supplier<RadioButton[]> group, class_2960 texture, int tx, int ty, int tw, int th, int tsX, int tsY, Consumer<RadioButton> onPress) {
        super(x, y, w, h, title);
        this.selected = selected;
        this.showLabel = showLabel;
        this.group = group;
        this.texture = texture;
        this.textureX = tx;
        this.textureY = ty;
        this.textureWidth = tw;
        this.textureHeight = th;
        this.textureSizeWidth = tsX;
        this.textureSizeHeight = tsY;
        this.onPress = onPress;
    }

    @Override
    public void method_25306() {
        this.selected = true;
        var rdos = this.group.get();
        for (RadioButton rdo : rdos) {
            if (this != rdo) {
                rdo.selected = false;
            }
        }
        this.onPress.accept(this);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean selected() {
        return this.selected;
    }

    @Override
    public void method_37020(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, new class_2588("narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, new class_2588("narration.checkbox.usage.hovered"));
            }
        }
    }

    @Override
    public void method_25359(class_4587 poseStack, int i, int j, float f) {
        OERenderUtil.drawTexture(texture, poseStack, field_22760, field_22761, textureX + (this.method_25367() ? 20 : 0), textureY + (this.selected ? 20 : 0), textureWidth, textureHeight, textureSizeWidth, textureSizeHeight);
        this.method_25353(poseStack, mc, i, j);
        if (this.showLabel) {
            drawRdoString(poseStack, this.method_25369(), this.field_22760 + 24, this.field_22761 + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
        }
    }

    public void drawRdoString(class_4587 poseStack, class_2561 component, int i, int j, int k) {
        method_27535(poseStack, mc.field_1772, component, i, j, k);
    }
}
