package dev.felnull.otyacraftengine.blockentity;

import dev.architectury.hooks.block.BlockEntityHooks;
import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.block.TestBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class TestBlockEntity extends OEBaseBlockEntity {
    public static class_2591<TestBlockEntity> TEST_BLOCKENTITY;
    private float roted;
    private float oldRoted;

    public TestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TEST_BLOCKENTITY, blockPos, blockState);
    }

    public static void init() {
        DeferredRegister<class_2591<?>> BLOCK_ENTITY_TYPES_REGISTER = DeferredRegister.create(OtyacraftEngine.MODID, class_2378.field_25073);
        TEST_BLOCKENTITY = BlockEntityHooks.builder(TestBlockEntity::new, TestBlock.TEST_BLOCK).build(null);
        BLOCK_ENTITY_TYPES_REGISTER.register("test_block_entity", () -> TEST_BLOCKENTITY);
        BLOCK_ENTITY_TYPES_REGISTER.register();
    }

    public float getOldRoted() {
        return oldRoted;
    }

    public float getRoted() {
        return roted;
    }

    public void test() {
        sync();
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, TestBlockEntity blockEntity) {
        blockEntity.oldRoted = blockEntity.roted;
        blockEntity.roted += 3;

        if (!level.method_8608()) {
            blockEntity.sync();
        }
    }

    @Override
    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        //  tag.putFloat("roted", roted);
        //   tag.putFloat("oldRoted", oldRoted);
        return tag;
    }

    @Override
    public void onSync(class_2487 tag) {
        // this.roted = tag.getFloat("roted");
        //   this.oldRoted = tag.getFloat("oldRoted");
    }
}
