package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.blockentity.IClientSyncbleBlockEntity;
import dev.felnull.otyacraftengine.client.gui.screen.IInstructionBEScreen;
import dev.felnull.otyacraftengine.client.gui.screen.IInstructionItemScreen;
import dev.felnull.otyacraftengine.networking.OEPackets;
import net.minecraft.class_310;
import var;

public class ClientMessageHandler {
    private static final class_310 mc = class_310.method_1551();

    public static void onTestMessage(OEPackets.TestMessage message, NetworkManager.PacketContext packetContext) {
        System.out.println(message.str);
        System.out.println(message.num);
    }

    public static void onBlockEntitySyncMessage(OEPackets.BlockEntitySyncMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            if (!message.blockEntityExistence.check(mc.field_1687))
                return;
            var be = (IClientSyncbleBlockEntity) mc.field_1687.method_8321(message.blockEntityExistence.blockPos());
            be.onSync(message.syncedData);
        });
    }

    public static void onBlockEntityInstructionReturn(OEPackets.BlockEntityInstructionMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            if (!message.blockEntityExistence.check(mc.field_1687))
                return;
            if (mc.field_1755 instanceof IInstructionBEScreen insScreen && insScreen.getInstructionID().equals(message.instructionScreenID))
                insScreen.onInstructionReturn(message.name, message.num, message.data);
        });
    }

    public static void onItemInstructionReturn(OEPackets.ItemInstructionMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            if (!message.itemExistence.check(mc.field_1724))
                return;
            if (mc.field_1755 instanceof IInstructionItemScreen insScreen && insScreen.getInstructionID().equals(message.instructionScreenID))
                insScreen.onInstructionReturn(message.name, message.num, message.data);
        });
    }
}
