package dev.felnull.otyacraftengine.block;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.blockentity.TestBlockEntity;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class TestBlock extends HorizontalDirectionalEntityBlock {

    public TestBlock(class_2251 properties) {
        super(properties);
    }

    public static RegistrySupplier<class_2248> TEST_BLOCK;

    public static void init() {
        DeferredRegister<class_2248> BLOCK_REG = DeferredRegister.create(OtyacraftEngine.MODID, class_2378.field_25105);
        DeferredRegister<class_1792> ITEM_REG = DeferredRegister.create(OtyacraftEngine.MODID, class_2378.field_25108);
        TEST_BLOCK = BLOCK_REG.register("test_block", () -> new TestBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9626(class_2498.field_11533)));
        BLOCK_REG.register();
        ITEM_REG.register("test_block", () -> new class_1747(TEST_BLOCK.get(), new class_1792.class_1793().method_7892(class_1761.field_7932)));
        ITEM_REG.register();
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new TestBlockEntity(blockPos, blockState);
    }

    @Override
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11455;
    }

    private static final class_265 testShape = class_259.method_1081(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);

    @Override
    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return testShape;
    }

    private static final class_265 shape = OEVoxelShapeUtil.rotateBoxY90(OEVoxelShapeUtil.getShapeFromResource(new class_2960(OtyacraftEngine.MODID, "sample")));

    /*@Override
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return shape;
    }*/

    @Override
    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (!level.method_8608()) {
            openContainer(level, blockPos, (class_3222) player, blockState, blockHitResult.method_17780());
        }
        return class_1269.method_29236(level.method_8608());
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return method_31618(blockEntityType, TestBlockEntity.TEST_BLOCKENTITY.get(), TestBlockEntity::tick);
    }
}
